/*
 * Decompiled with CFR 0.152.
 */
package com.documents4j.job;

import com.documents4j.api.IInputStreamSource;
import com.documents4j.throwables.FileSystemInteractionException;
import com.google.common.base.MoreObjects;
import com.google.common.io.Closeables;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;

class InputStreamSourceFromInputStream
implements IInputStreamSource {
    private final InputStream inputStream;
    private final boolean close;

    public InputStreamSourceFromInputStream(InputStream inputStream, boolean close) {
        this.inputStream = inputStream;
        this.close = close;
    }

    public InputStream getInputStream() {
        return this.inputStream;
    }

    public void onConsumed(InputStream inputStream) {
        try {
            if (this.close) {
                Closeables.close((Closeable)inputStream, (boolean)false);
            }
        }
        catch (IOException e) {
            throw new FileSystemInteractionException("Could not close input stream", (Throwable)e);
        }
    }

    public String toString() {
        return MoreObjects.toStringHelper(InputStreamSourceFromInputStream.class).add("inputStream", (Object)this.inputStream).add("close", this.close).toString();
    }
}

