/*
 * Decompiled with CFR 0.152.
 */
package com.dtflys.forest.springboot;

import com.dtflys.forest.config.ForestConfiguration;
import com.dtflys.forest.config.ForestProperties;
import com.dtflys.forest.config.SpringForestProperties;
import com.dtflys.forest.converter.ForestConverter;
import com.dtflys.forest.converter.auto.DefaultAutoConverter;
import com.dtflys.forest.exceptions.ForestRuntimeException;
import com.dtflys.forest.interceptor.InterceptorFactory;
import com.dtflys.forest.interceptor.SpringInterceptorFactory;
import com.dtflys.forest.logging.ForestLogHandler;
import com.dtflys.forest.reflection.ForestObjectFactory;
import com.dtflys.forest.reflection.SpringForestObjectFactory;
import com.dtflys.forest.scanner.ClassPathClientScanner;
import com.dtflys.forest.schema.ForestConfigurationBeanDefinitionParser;
import com.dtflys.forest.spring.ConverterBeanListener;
import com.dtflys.forest.springboot.annotation.ForestScannerRegister;
import com.dtflys.forest.springboot.properties.ForestConfigurationProperties;
import com.dtflys.forest.springboot.properties.ForestConvertProperties;
import com.dtflys.forest.springboot.properties.ForestConverterItemProperties;
import com.dtflys.forest.springboot.properties.ForestSSLKeyStoreProperties;
import com.dtflys.forest.utils.ForestDataType;
import com.dtflys.forest.utils.StringUtils;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.ManagedMap;
import org.springframework.cglib.core.ReflectUtils;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.ResourceLoaderAware;
import org.springframework.core.io.ResourceLoader;

public class ForestBeanRegister
implements ResourceLoaderAware,
BeanPostProcessor {
    private final ConfigurableApplicationContext applicationContext;
    private ResourceLoader resourceLoader;
    private SpringForestProperties properties;
    private SpringForestObjectFactory forestObjectFactory;
    private SpringInterceptorFactory forestInterceptorFactory;
    private ForestConfigurationProperties forestConfigurationProperties;

    public ForestBeanRegister(ConfigurableApplicationContext applicationContext, ForestConfigurationProperties forestConfigurationProperties, SpringForestProperties properties, SpringForestObjectFactory forestObjectFactory, SpringInterceptorFactory forestInterceptorFactory) {
        this.applicationContext = applicationContext;
        this.properties = properties;
        this.forestObjectFactory = forestObjectFactory;
        this.forestConfigurationProperties = forestConfigurationProperties;
        this.forestInterceptorFactory = forestInterceptorFactory;
    }

    public void setResourceLoader(ResourceLoader resourceLoader) {
        this.resourceLoader = resourceLoader;
    }

    public ForestConfiguration registerForestConfiguration() {
        BeanDefinitionBuilder beanDefinitionBuilder = BeanDefinitionBuilder.genericBeanDefinition(ForestConfiguration.class);
        String id = this.forestConfigurationProperties.getBeanId();
        if (StringUtils.isBlank((String)id)) {
            id = "forestConfiguration";
        }
        Class<? extends ForestLogHandler> logHandlerClass = this.forestConfigurationProperties.getLogHandler();
        ForestLogHandler logHandler = null;
        if (logHandlerClass != null) {
            try {
                logHandler = logHandlerClass.newInstance();
            }
            catch (InstantiationException e) {
                throw new ForestRuntimeException((Throwable)e);
            }
            catch (IllegalAccessException e) {
                throw new ForestRuntimeException((Throwable)e);
            }
        }
        beanDefinitionBuilder.addPropertyValue("maxAsyncThreadSize", (Object)this.forestConfigurationProperties.getMaxAsyncThreadSize()).addPropertyValue("maxAsyncQueueSize", (Object)this.forestConfigurationProperties.getMaxAsyncQueueSize()).addPropertyValue("maxConnections", (Object)this.forestConfigurationProperties.getMaxConnections()).addPropertyValue("maxRouteConnections", (Object)this.forestConfigurationProperties.getMaxRouteConnections()).addPropertyValue("asyncMode", (Object)this.forestConfigurationProperties.getAsyncMode()).addPropertyValue("timeout", (Object)this.forestConfigurationProperties.getTimeout()).addPropertyValue("connectTimeout", (Object)this.forestConfigurationProperties.getConnectTimeoutMillis()).addPropertyValue("readTimeout", (Object)this.forestConfigurationProperties.getReadTimeoutMillis()).addPropertyValue("charset", (Object)this.forestConfigurationProperties.getCharset()).addPropertyValue("retryer", (Object)this.forestConfigurationProperties.getRetryer()).addPropertyValue("maxRetryCount", (Object)this.forestConfigurationProperties.getMaxRetryCount()).addPropertyValue("maxRetryInterval", (Object)this.forestConfigurationProperties.getMaxRetryInterval()).addPropertyValue("autoRedirection", (Object)this.forestConfigurationProperties.isAutoRedirection()).addPropertyValue("logEnabled", (Object)this.forestConfigurationProperties.isLogEnabled()).addPropertyValue("logRequest", (Object)this.forestConfigurationProperties.isLogRequest()).addPropertyValue("logResponseStatus", (Object)this.forestConfigurationProperties.isLogResponseStatus()).addPropertyValue("logResponseContent", (Object)this.forestConfigurationProperties.isLogResponseContent()).addPropertyValue("logHandler", (Object)logHandler).addPropertyValue("backendName", (Object)this.forestConfigurationProperties.getBackend()).addPropertyValue("backendClientCacheMaxSize", (Object)this.forestConfigurationProperties.getBackendClientCacheMaxSize()).addPropertyValue("backendClientCacheExpireTime", (Object)this.forestConfigurationProperties.getBackendClientCacheExpireTime()).addPropertyValue("baseAddressScheme", (Object)this.forestConfigurationProperties.getBaseAddressScheme()).addPropertyValue("baseAddressHost", (Object)this.forestConfigurationProperties.getBaseAddressHost()).addPropertyValue("baseAddressPort", (Object)this.forestConfigurationProperties.getBaseAddressPort()).addPropertyValue("baseAddressSourceClass", this.forestConfigurationProperties.getBaseAddressSource()).addPropertyValue("successWhenClass", this.forestConfigurationProperties.getSuccessWhen()).addPropertyValue("retryWhenClass", this.forestConfigurationProperties.getRetryWhen()).addPropertyValue("interceptors", this.forestConfigurationProperties.getInterceptors()).addPropertyValue("sslProtocol", (Object)this.forestConfigurationProperties.getSslProtocol()).addPropertyValue("variables", this.forestConfigurationProperties.getVariables()).setLazyInit(false).setFactoryMethod("configuration").addConstructorArgValue((Object)id);
        List<ForestSSLKeyStoreProperties> sslKeyStorePropertiesList = this.forestConfigurationProperties.getSslKeyStores();
        ManagedMap sslKeystoreMap = new ManagedMap();
        for (ForestSSLKeyStoreProperties keyStoreProperties : sslKeyStorePropertiesList) {
            this.registerSSLKeyStoreBean((ManagedMap<String, BeanDefinition>)sslKeystoreMap, keyStoreProperties);
        }
        AbstractBeanDefinition beanDefinition = beanDefinitionBuilder.getRawBeanDefinition();
        beanDefinition.getPropertyValues().addPropertyValue("sslKeyStores", (Object)sslKeystoreMap);
        BeanDefinitionRegistry beanFactory = (BeanDefinitionRegistry)this.applicationContext.getBeanFactory();
        beanFactory.registerBeanDefinition(id, (BeanDefinition)beanDefinition);
        ForestConfiguration configuration = (ForestConfiguration)this.applicationContext.getBean(id, ForestConfiguration.class);
        configuration.setProperties((ForestProperties)this.properties);
        configuration.setForestObjectFactory((ForestObjectFactory)this.forestObjectFactory);
        configuration.setInterceptorFactory((InterceptorFactory)this.forestInterceptorFactory);
        Map<String, Class> filters = this.forestConfigurationProperties.getFilters();
        for (Map.Entry<String, Class> entry : filters.entrySet()) {
            String filterName = entry.getKey();
            Class filterClass = entry.getValue();
            configuration.registerFilter(filterName, filterClass);
        }
        ForestConvertProperties convertProperties = this.forestConfigurationProperties.getConverters();
        if (convertProperties != null) {
            this.registerConverter(configuration, ForestDataType.TEXT, convertProperties.getText());
            this.registerConverter(configuration, ForestDataType.JSON, convertProperties.getJson());
            this.registerConverter(configuration, ForestDataType.XML, convertProperties.getXml());
            this.registerConverter(configuration, ForestDataType.BINARY, convertProperties.getBinary());
            this.registerConverter(configuration, ForestDataType.PROTOBUF, convertProperties.getProtobuf());
        }
        this.registerConverterBeanListener(configuration);
        return configuration;
    }

    public ConverterBeanListener registerConverterBeanListener(ForestConfiguration forestConfiguration) {
        BeanDefinitionBuilder beanDefinitionBuilder = BeanDefinitionBuilder.genericBeanDefinition(ConverterBeanListener.class);
        AbstractBeanDefinition beanDefinition = beanDefinitionBuilder.getRawBeanDefinition();
        beanDefinition.getPropertyValues().addPropertyValue("forestConfiguration", (Object)forestConfiguration);
        BeanDefinitionRegistry beanFactory = (BeanDefinitionRegistry)this.applicationContext.getBeanFactory();
        beanFactory.registerBeanDefinition("forestConverterBeanListener", (BeanDefinition)beanDefinition);
        return (ConverterBeanListener)this.applicationContext.getBean("forestConverterBeanListener", ConverterBeanListener.class);
    }

    private void registerConverter(ForestConfiguration configuration, ForestDataType dataType, ForestConverterItemProperties converterItemProperties) {
        if (converterItemProperties == null) {
            return;
        }
        Class<? extends ForestConverter> type = converterItemProperties.getType();
        if (type != null) {
            ForestConverter converter = null;
            try {
                PropertyDescriptor[] descriptors;
                Constructor<?>[] constructors = type.getConstructors();
                List<Constructor<?>> sortedConstructs = Arrays.stream(constructors).sorted((cons1, cons2) -> cons1.getParameterCount() < cons2.getParameterCount() ? 1 : -1).toList();
                for (Constructor<?> constructor : sortedConstructs) {
                    Parameter[] params = constructor.getParameters();
                    if (params.length == 0) {
                        converter = (ForestConverter)constructor.newInstance(new Object[0]);
                        break;
                    }
                    Object[] args = new Object[params.length];
                    Class<?>[] pTypes = constructor.getParameterTypes();
                    for (int i = 0; i < params.length; ++i) {
                        Object instance;
                        block18: {
                            Class<?> pType = pTypes[i];
                            if (ForestConfiguration.class.isAssignableFrom(pType)) {
                                args[i] = configuration;
                                continue;
                            }
                            if (DefaultAutoConverter.class.isAssignableFrom(pType)) {
                                args[i] = configuration.getConverter(ForestDataType.AUTO);
                                continue;
                            }
                            instance = configuration.getForestObject(pType);
                            if (instance == null) {
                                try {
                                    Constructor<?> cons = pType.getConstructor(new Class[0]);
                                    if (cons == null) break block18;
                                    instance = cons.newInstance(new Object[0]);
                                }
                                catch (NoSuchMethodException e) {
                                    continue;
                                }
                            }
                        }
                        args[i] = instance;
                    }
                    converter = (ForestConverter)constructor.newInstance(args);
                }
                Map<String, Object> parameters = converterItemProperties.getParameters();
                for (PropertyDescriptor descriptor : descriptors = ReflectUtils.getBeanSetters(type)) {
                    String name = descriptor.getName();
                    Object value = parameters.get(name);
                    Method method = descriptor.getWriteMethod();
                    if (method == null) continue;
                    try {
                        method.invoke((Object)converter, value);
                    }
                    catch (IllegalAccessException e) {
                        throw new ForestRuntimeException("An error occurred during setting the property " + type.getName() + "." + name, (Throwable)e);
                    }
                    catch (InvocationTargetException e) {
                        throw new ForestRuntimeException("An error occurred during setting the property " + type.getName() + "." + name, (Throwable)e);
                    }
                }
                configuration.getConverterMap().put(dataType, converter);
            }
            catch (InstantiationException e) {
                throw new ForestRuntimeException("[Forest] Convert type '" + type.getName() + "' cannot be initialized!", (Throwable)e);
            }
            catch (IllegalAccessException e) {
                throw new ForestRuntimeException("[Forest] Convert type '" + type.getName() + "' cannot be initialized!", (Throwable)e);
            }
            catch (InvocationTargetException e) {
                throw new ForestRuntimeException("[Forest] Convert type '" + type.getName() + "' cannot be initialized!", (Throwable)e);
            }
        }
    }

    public BeanDefinition registerSSLKeyStoreBean(ManagedMap<String, BeanDefinition> map, ForestSSLKeyStoreProperties sslKeyStoreProperties) {
        String id = sslKeyStoreProperties.getId();
        if (StringUtils.isBlank((String)id)) {
            throw new ForestRuntimeException("[Forest] Property 'id' of SSL keystore can not be empty or blank");
        }
        if (map.containsKey((Object)id)) {
            throw new ForestRuntimeException("[Forest] Duplicate SSL keystore id '" + id + "'");
        }
        BeanDefinition beanDefinition = ForestConfigurationBeanDefinitionParser.createSSLKeyStoreBean((String)id, (String)sslKeyStoreProperties.getType(), (String)sslKeyStoreProperties.getFile(), (String)sslKeyStoreProperties.getKeystorePass(), (String)sslKeyStoreProperties.getCertPass(), (String)sslKeyStoreProperties.getProtocols(), (String)sslKeyStoreProperties.getCipherSuites(), (String)sslKeyStoreProperties.getTrustManager(), (String)sslKeyStoreProperties.getHostnameVerifier(), (String)sslKeyStoreProperties.getSslSocketFactoryBuilder());
        map.put((Object)id, (Object)beanDefinition);
        return beanDefinition;
    }

    public ClassPathClientScanner registerScanner() {
        List<String> basePackages = ForestScannerRegister.getBasePackages();
        String configurationId = ForestScannerRegister.getConfigurationId();
        BeanDefinitionRegistry registry = (BeanDefinitionRegistry)this.applicationContext.getBeanFactory();
        ClassPathClientScanner scanner = new ClassPathClientScanner(configurationId, registry);
        if (this.resourceLoader != null) {
            scanner.setResourceLoader(this.resourceLoader);
        }
        if (basePackages == null || basePackages.size() == 0) {
            return scanner;
        }
        scanner.doScan(org.springframework.util.StringUtils.toStringArray(basePackages));
        return scanner;
    }

    public Object postProcessBeforeInitialization(Object bean, String beanName) throws BeansException {
        return bean;
    }

    public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
        return bean;
    }
}

