/*
 * Decompiled with CFR 0.152.
 */
package com.egzosn.pay.wx.v3.utils;

import com.egzosn.pay.common.bean.result.PayError;
import com.egzosn.pay.common.exception.PayErrorException;
import com.egzosn.pay.common.util.sign.SignUtils;
import com.egzosn.pay.common.util.sign.encrypt.Base64;
import com.egzosn.pay.wx.bean.WxPayError;
import com.egzosn.pay.wx.v3.bean.CertEnvironment;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Security;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.crypto.Cipher;
import javax.crypto.spec.GCMParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import javax.management.openmbean.InvalidKeyException;

public final class AntCertificationUtil {
    private static final Map<String, Certificate> CERTIFICATE_MAP = new ConcurrentHashMap<String, Certificate>();
    private static final KeyStore PKCS12_KEY_STORE;
    private static final CertificateFactory CERTIFICATE_FACTORY;

    private AntCertificationUtil() {
    }

    public static Certificate loadCertificate(String serialNo, InputStream certificateStream) {
        try {
            Certificate certificate = CERTIFICATE_FACTORY.generateCertificate(certificateStream);
            CERTIFICATE_MAP.put(serialNo, certificate);
            return certificate;
        }
        catch (CertificateException e) {
            throw new PayErrorException((PayError)new WxPayError("failure", " \u5728\u751f\u6210\u5fae\u4fe1v3\u8bc1\u4e66\u65f6\u53d1\u751f\u9519\u8bef\uff0c\u539f\u56e0\u662f" + e.getMessage()), (Throwable)e);
        }
    }

    public static Certificate getCertificate(String serialNo) {
        return CERTIFICATE_MAP.get(serialNo);
    }

    public static CertEnvironment initCertification(InputStream keyCertStream, String keyAlias, String keyPass) {
        char[] pem = keyPass.toCharArray();
        try {
            PKCS12_KEY_STORE.load(keyCertStream, pem);
            X509Certificate certificate = (X509Certificate)PKCS12_KEY_STORE.getCertificate(keyAlias);
            certificate.checkValidity();
            String serialNumber = certificate.getSerialNumber().toString(16).toUpperCase();
            PublicKey publicKey = certificate.getPublicKey();
            PrivateKey privateKey = (PrivateKey)PKCS12_KEY_STORE.getKey(keyAlias, pem);
            return new CertEnvironment(privateKey, publicKey, serialNumber);
        }
        catch (InvalidKeyException e) {
            throw new PayErrorException((PayError)new WxPayError("failure", "\u83b7\u53d6\u516c\u79c1\u94a5\u5931\u8d25\uff0c \u89e3\u51b3\u65b9\u5f0f\uff1a\u66ff\u6362jre\u5305\uff1alocal_policy.jar\uff0cUS_export_policy.jar"), (Throwable)e);
        }
        catch (GeneralSecurityException e) {
            throw new PayErrorException((PayError)new WxPayError("failure", "\u83b7\u53d6\u516c\u79c1\u94a5\u5931\u8d25"), (Throwable)e);
        }
        catch (IOException e) {
            throw new PayErrorException((PayError)new WxPayError("failure", "\u79c1\u94a5\u8bc1\u4e66\u6d41\u52a0\u8f7d\u5931\u8d25"), (Throwable)e);
        }
    }

    public static String decryptToString(String associatedData, String nonce, String cipherText, String secretKey, String characterEncoding) {
        try {
            Cipher cipher = Cipher.getInstance("AES/GCM/NoPadding", "BC");
            SecretKeySpec key = new SecretKeySpec(secretKey.getBytes(Charset.forName(characterEncoding)), "AES");
            GCMParameterSpec spec = new GCMParameterSpec(128, nonce.getBytes(Charset.forName(characterEncoding)));
            cipher.init(2, (Key)key, spec);
            cipher.updateAAD(associatedData.getBytes(Charset.forName(characterEncoding)));
            byte[] bytes = cipher.doFinal(Base64.decode((String)cipherText));
            return new String(bytes, Charset.forName(characterEncoding));
        }
        catch (GeneralSecurityException e) {
            throw new PayErrorException((PayError)new WxPayError("failure", e.getMessage()), (Throwable)e);
        }
    }

    public static String encryptToString(String message, Certificate certificate) {
        try {
            Cipher cipher = Cipher.getInstance("RSA/ECB/OAEPWithSHA-1AndMGF1Padding", "BC");
            cipher.init(1, certificate.getPublicKey());
            byte[] data = message.getBytes(StandardCharsets.UTF_8);
            byte[] cipherData = cipher.doFinal(data);
            return Base64.encode((byte[])cipherData);
        }
        catch (GeneralSecurityException e) {
            throw new PayErrorException((PayError)new WxPayError("failure", e.getMessage()), (Throwable)e);
        }
    }

    static {
        String javaVersion = System.getProperty("java.version");
        if (javaVersion.contains("1.8") || javaVersion.startsWith("8")) {
            Security.setProperty("crypto.policy", "unlimited");
        }
        SignUtils.initBc();
        try {
            PKCS12_KEY_STORE = KeyStore.getInstance("PKCS12");
        }
        catch (KeyStoreException e) {
            throw new PayErrorException((PayError)new WxPayError("failure", " keystore \u521d\u59cb\u5316\u5931\u8d25"), (Throwable)e);
        }
        try {
            CERTIFICATE_FACTORY = CertificateFactory.getInstance("X509", "BC");
        }
        catch (NoSuchProviderException | CertificateException e) {
            throw new PayErrorException((PayError)new WxPayError("failure", " keystore \u521d\u59cb\u5316\u5931\u8d25"), (Throwable)e);
        }
    }
}

