/*
 * Decompiled with CFR 0.152.
 */
package com.egzosn.pay.spring.boot.core.builders;

import com.egzosn.pay.spring.boot.core.builders.MerchantDetailsServiceBuilder;
import com.egzosn.pay.spring.boot.core.merchant.MerchantDetailsService;
import com.egzosn.pay.spring.boot.core.merchant.bean.CommonPaymentPlatformMerchantDetails;
import com.egzosn.pay.spring.boot.core.provider.CacheMerchantDetailsManager;
import com.egzosn.pay.spring.boot.core.provider.JdbcMerchantDetailsManager;
import com.egzosn.pay.spring.boot.core.provider.MerchantDetailsManager;
import javax.sql.DataSource;
import org.springframework.jdbc.core.JdbcTemplate;

public class JdbcMerchantDetailsServiceBuilder
extends MerchantDetailsServiceBuilder {
    private JdbcTemplate jdbcTemplate;
    private boolean cache = false;

    public JdbcMerchantDetailsServiceBuilder(DataSource source) {
        this.setJdbcTemplate(new JdbcTemplate(source));
    }

    public JdbcMerchantDetailsServiceBuilder(JdbcTemplate jdbcTemplate) {
        this.jdbcTemplate = jdbcTemplate;
    }

    public JdbcMerchantDetailsServiceBuilder(boolean cache) {
        this.cache = cache;
    }

    public JdbcMerchantDetailsServiceBuilder() {
    }

    public JdbcMerchantDetailsServiceBuilder cache(boolean cache) {
        this.setCache(cache);
        return this;
    }

    public JdbcMerchantDetailsServiceBuilder template(JdbcTemplate jdbcTemplate) {
        this.setJdbcTemplate(jdbcTemplate);
        return this;
    }

    public JdbcMerchantDetailsServiceBuilder dataSource(DataSource source) {
        this.setJdbcTemplate(new JdbcTemplate(source));
        return this;
    }

    public JdbcTemplate getJdbcTemplate() {
        return this.jdbcTemplate;
    }

    private void setJdbcTemplate(JdbcTemplate jdbcTemplate) {
        if (null != this.jdbcTemplate) {
            return;
        }
        this.jdbcTemplate = jdbcTemplate;
    }

    public boolean isCache() {
        return this.cache;
    }

    public void setCache(boolean cache) {
        this.cache = cache;
    }

    @Override
    protected MerchantDetailsService performBuild() {
        MerchantDetailsManager<CommonPaymentPlatformMerchantDetails> manager = new JdbcMerchantDetailsManager(this.jdbcTemplate);
        if (this.cache) {
            manager = new CacheMerchantDetailsManager(manager);
        }
        manager.setPayMessageConfigurer(this.configurer);
        return manager;
    }
}

