/*
 * Decompiled with CFR 0.152.
 */
package com.egzosn.pay.spring.boot.core.merchant.bean;

import com.egzosn.pay.common.api.PayService;
import com.egzosn.pay.common.http.HttpConfigStorage;
import com.egzosn.pay.payoneer.api.PayoneerConfigStorage;
import com.egzosn.pay.spring.boot.core.PayConfigurerAdapter;
import com.egzosn.pay.spring.boot.core.builders.InMemoryMerchantDetailsServiceBuilder;
import com.egzosn.pay.spring.boot.core.merchant.PaymentPlatform;
import com.egzosn.pay.spring.boot.core.merchant.PaymentPlatformMerchantDetails;
import com.egzosn.pay.spring.boot.core.merchant.PaymentPlatformServiceAdapter;
import com.egzosn.pay.spring.boot.core.provider.merchant.platform.PaymentPlatforms;

public class PayoneerMerchantDetails
extends PayoneerConfigStorage
implements PaymentPlatformMerchantDetails,
PaymentPlatformServiceAdapter,
PayConfigurerAdapter<InMemoryMerchantDetailsServiceBuilder> {
    private String detailsId;
    private volatile PayService payService;
    private PaymentPlatform platform;
    private InMemoryMerchantDetailsServiceBuilder builder;
    private HttpConfigStorage httpConfigStorage;

    @Override
    public InMemoryMerchantDetailsServiceBuilder and() {
        this.initService();
        return this.getBuilder();
    }

    @Override
    public InMemoryMerchantDetailsServiceBuilder getBuilder() {
        return this.builder;
    }

    public PayoneerMerchantDetails(InMemoryMerchantDetailsServiceBuilder builder) {
        this();
        this.builder = builder;
    }

    public PayoneerMerchantDetails() {
        String platformName = "payoneerPay";
        this.setPayType(platformName);
        this.platform = PaymentPlatforms.getPaymentPlatform(platformName);
    }

    @Override
    public PaymentPlatform getPaymentPlatform() {
        return this.platform;
    }

    @Override
    public PaymentPlatformServiceAdapter initService() {
        if (null == this.payService) {
            this.payService = this.platform.getPayService(this, this.getHttpConfigStorage());
        }
        return this;
    }

    public PayService getPayService() {
        return this.payService;
    }

    @Override
    public HttpConfigStorage getHttpConfigStorage() {
        return this.httpConfigStorage;
    }

    public PayoneerMerchantDetails httpConfigStorage(HttpConfigStorage httpConfigStorage) {
        this.httpConfigStorage = httpConfigStorage;
        return this;
    }

    @Override
    public String getDetailsId() {
        return this.detailsId;
    }

    public PayoneerMerchantDetails detailsId(String detailsId) {
        this.detailsId = detailsId;
        return this;
    }

    public PayoneerMerchantDetails programId(String programId) {
        this.setProgramId(programId);
        return this;
    }

    public PayoneerMerchantDetails userName(String userName) {
        this.setUserName(userName);
        return this;
    }

    public PayoneerMerchantDetails apiPassword(String apiPassword) {
        this.setApiPassword(apiPassword);
        return this;
    }

    public PayoneerMerchantDetails signType(String signType) {
        this.setSignType(signType);
        return this;
    }

    public PayoneerMerchantDetails inputCharset(String inputCharset) {
        this.setInputCharset(inputCharset);
        return this;
    }

    public PayoneerMerchantDetails test(boolean test) {
        this.setTest(test);
        return this;
    }
}

