/*
 * Decompiled with CFR 0.152.
 */
package com.egzosn.pay.spring.boot.core.merchant.bean;

import com.egzosn.pay.common.api.PayService;
import com.egzosn.pay.common.bean.CertStoreType;
import com.egzosn.pay.common.http.HttpConfigStorage;
import com.egzosn.pay.spring.boot.core.PayConfigurerAdapter;
import com.egzosn.pay.spring.boot.core.builders.InMemoryMerchantDetailsServiceBuilder;
import com.egzosn.pay.spring.boot.core.merchant.PaymentPlatform;
import com.egzosn.pay.spring.boot.core.merchant.PaymentPlatformMerchantDetails;
import com.egzosn.pay.spring.boot.core.merchant.PaymentPlatformServiceAdapter;
import com.egzosn.pay.spring.boot.core.provider.merchant.platform.PaymentPlatforms;
import com.egzosn.pay.union.api.UnionPayConfigStorage;
import java.io.InputStream;

public class UnionMerchantDetails
extends UnionPayConfigStorage
implements PaymentPlatformMerchantDetails,
PaymentPlatformServiceAdapter,
PayConfigurerAdapter<InMemoryMerchantDetailsServiceBuilder> {
    private String detailsId;
    private volatile PayService payService;
    private PaymentPlatform platform;
    private InMemoryMerchantDetailsServiceBuilder builder;
    private HttpConfigStorage httpConfigStorage;

    @Override
    public InMemoryMerchantDetailsServiceBuilder and() {
        this.initService();
        return this.getBuilder();
    }

    @Override
    public InMemoryMerchantDetailsServiceBuilder getBuilder() {
        return this.builder;
    }

    public UnionMerchantDetails(InMemoryMerchantDetailsServiceBuilder builder) {
        this();
        this.builder = builder;
    }

    public UnionMerchantDetails() {
        String platformName = "unionPay";
        this.setPayType(platformName);
        this.platform = PaymentPlatforms.getPaymentPlatform(platformName);
    }

    @Override
    public PaymentPlatform getPaymentPlatform() {
        return this.platform;
    }

    @Override
    public PaymentPlatformServiceAdapter initService() {
        if (null == this.payService) {
            this.payService = this.platform.getPayService(this, this.getHttpConfigStorage());
        }
        return this;
    }

    public PayService getPayService() {
        return this.payService;
    }

    @Override
    public HttpConfigStorage getHttpConfigStorage() {
        return this.httpConfigStorage;
    }

    public UnionMerchantDetails httpConfigStorage(HttpConfigStorage httpConfigStorage) {
        this.httpConfigStorage = httpConfigStorage;
        return this;
    }

    @Override
    public String getDetailsId() {
        return this.detailsId;
    }

    public UnionMerchantDetails detailsId(String detailsId) {
        this.detailsId = detailsId;
        return this;
    }

    public UnionMerchantDetails notifyUrl(String notifyUrl) {
        this.setNotifyUrl(notifyUrl);
        return this;
    }

    public UnionMerchantDetails returnUrl(String returnUrl) {
        this.setReturnUrl(returnUrl);
        return this;
    }

    public UnionMerchantDetails signType(String signType) {
        this.setSignType(signType);
        return this;
    }

    public UnionMerchantDetails inputCharset(String inputCharset) {
        this.setInputCharset(inputCharset);
        return this;
    }

    public UnionMerchantDetails test(boolean test) {
        this.setTest(test);
        return this;
    }

    public UnionMerchantDetails acpMiddleCert(String acpMiddleCert) {
        this.setAcpMiddleCert(acpMiddleCert);
        return this;
    }

    public UnionMerchantDetails acpMiddleCert(InputStream acpMiddleCert) {
        this.setAcpMiddleCert(acpMiddleCert);
        return this;
    }

    public UnionMerchantDetails acpRootCert(String acpRootCert) {
        this.setAcpRootCert(acpRootCert);
        return this;
    }

    public UnionMerchantDetails acpRootCert(InputStream acpRootCert) {
        this.setAcpRootCert(acpRootCert);
        return this;
    }

    public UnionMerchantDetails keyPrivateCert(String keyPrivateCert) {
        this.setKeyPrivateCert(keyPrivateCert);
        return this;
    }

    public UnionMerchantDetails keyPrivateCert(InputStream keyPrivateCert) {
        this.setKeyPrivateCert(keyPrivateCert);
        return this;
    }

    public UnionMerchantDetails keyPrivateCertPwd(String keyPrivateCertPwd) {
        this.setKeyPrivateCertPwd(keyPrivateCertPwd);
        return this;
    }

    public UnionMerchantDetails certStoreType(CertStoreType certStoreType) {
        this.setCertStoreType(certStoreType);
        return this;
    }
}

