/*
 * Decompiled with CFR 0.152.
 */
package com.egzosn.pay.spring.boot.core.provider.merchant.platform;

import com.egzosn.pay.ali.api.AliPayConfigStorage;
import com.egzosn.pay.ali.api.AliPayService;
import com.egzosn.pay.ali.bean.AliTransactionType;
import com.egzosn.pay.common.api.CertStore;
import com.egzosn.pay.common.api.PayConfigStorage;
import com.egzosn.pay.common.api.PayService;
import com.egzosn.pay.common.bean.TransactionType;
import com.egzosn.pay.common.http.HttpConfigStorage;
import com.egzosn.pay.spring.boot.core.merchant.PaymentPlatform;
import com.egzosn.pay.spring.boot.core.merchant.bean.CommonPaymentPlatformMerchantDetails;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.annotation.Configuration;

@Configuration(value="aliPay")
@ConditionalOnMissingBean(value={AliPaymentPlatform.class})
@ConditionalOnClass(name={"com.egzosn.pay.ali.api.AliPayConfigStorage"})
public class AliPaymentPlatform
implements PaymentPlatform {
    public static final String PLATFORM_NAME = "aliPay";
    @Deprecated
    public static final String platformName = "aliPay";

    @Override
    public String getPlatform() {
        return "aliPay";
    }

    public PayService getPayService(PayConfigStorage payConfigStorage) {
        if (payConfigStorage instanceof AliPayConfigStorage) {
            return new AliPayService((AliPayConfigStorage)payConfigStorage);
        }
        AliPayConfigStorage configStorage = new AliPayConfigStorage();
        configStorage.setInputCharset(payConfigStorage.getInputCharset());
        configStorage.setAppId(payConfigStorage.getAppId());
        configStorage.setPid(payConfigStorage.getPid());
        configStorage.setAttach(payConfigStorage.getAttach());
        configStorage.setSeller(payConfigStorage.getSeller());
        configStorage.setKeyPrivate(payConfigStorage.getKeyPrivate());
        configStorage.setKeyPublic(payConfigStorage.getKeyPublic());
        configStorage.setNotifyUrl(payConfigStorage.getNotifyUrl());
        configStorage.setReturnUrl(payConfigStorage.getReturnUrl());
        configStorage.setPayType(payConfigStorage.getPayType());
        configStorage.setTest(payConfigStorage.isTest());
        configStorage.setSignType(payConfigStorage.getSignType());
        if (payConfigStorage instanceof CommonPaymentPlatformMerchantDetails) {
            CommonPaymentPlatformMerchantDetails commonPaymentPlatformMerchantDetails = (CommonPaymentPlatformMerchantDetails)payConfigStorage;
            configStorage.setAppAuthToken(commonPaymentPlatformMerchantDetails.getSubAppId());
            AliPaymentPlatform.certKeyPublic(configStorage, commonPaymentPlatformMerchantDetails);
        }
        return new AliPayService(configStorage);
    }

    private static void certKeyPublic(AliPayConfigStorage aliPayConfigStorage, CommonPaymentPlatformMerchantDetails payConfigStorage) {
        String keyPublicCert = payConfigStorage.getKeyPublic();
        if (!keyPublicCert.endsWith(".crt")) {
            return;
        }
        aliPayConfigStorage.setCertSign(true);
        aliPayConfigStorage.setCertStoreType((CertStore)payConfigStorage.getCertStoreType());
        String[] keyCert = payConfigStorage.getKeyCert().toString().split(",");
        aliPayConfigStorage.setMerchantCert((Object)keyCert[0]);
        aliPayConfigStorage.setAliPayRootCert((Object)keyCert[1]);
        aliPayConfigStorage.setAliPayCert((Object)payConfigStorage.getKeyPublic());
    }

    public PayService getPayService(PayConfigStorage payConfigStorage, HttpConfigStorage httpConfigStorage) {
        PayService payService = this.getPayService(payConfigStorage);
        payService.setRequestTemplateConfigStorage(httpConfigStorage);
        return payService;
    }

    public TransactionType getTransactionType(String name) {
        return AliTransactionType.valueOf((String)name);
    }
}

