/*
 * Decompiled with CFR 0.152.
 */
package com.egzosn.pay.spring.boot.core.provider.merchant.platform;

import com.egzosn.pay.common.api.PayConfigStorage;
import com.egzosn.pay.common.api.PayService;
import com.egzosn.pay.common.bean.TransactionType;
import com.egzosn.pay.common.http.HttpConfigStorage;
import com.egzosn.pay.payoneer.api.PayoneerConfigStorage;
import com.egzosn.pay.payoneer.api.PayoneerPayService;
import com.egzosn.pay.payoneer.bean.PayoneerTransactionType;
import com.egzosn.pay.spring.boot.core.merchant.PaymentPlatform;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.annotation.Configuration;

@Configuration(value="payoneerPay")
@ConditionalOnMissingBean(value={PayoneerPaymentPlatform.class})
@ConditionalOnClass(name={"com.egzosn.pay.payoneer.api.PayoneerConfigStorage"})
public class PayoneerPaymentPlatform
implements PaymentPlatform {
    public static final String PLATFORM_NAME = "payoneerPay";
    @Deprecated
    public static final String platformName = "payoneerPay";

    @Override
    public String getPlatform() {
        return "payoneerPay";
    }

    public PayService getPayService(PayConfigStorage payConfigStorage) {
        if (payConfigStorage instanceof PayoneerConfigStorage) {
            return new PayoneerPayService((PayoneerConfigStorage)payConfigStorage);
        }
        PayoneerConfigStorage configStorage = new PayoneerConfigStorage();
        configStorage.setProgramId(payConfigStorage.getPid());
        configStorage.setUserName(payConfigStorage.getSeller());
        configStorage.setApiPassword(payConfigStorage.getKeyPrivate());
        configStorage.setNotifyUrl(payConfigStorage.getNotifyUrl());
        configStorage.setReturnUrl(payConfigStorage.getReturnUrl());
        configStorage.setSignType(payConfigStorage.getSignType());
        configStorage.setPayType(payConfigStorage.getPayType());
        configStorage.setInputCharset(payConfigStorage.getInputCharset());
        configStorage.setTest(payConfigStorage.isTest());
        return new PayoneerPayService(configStorage);
    }

    public PayService getPayService(PayConfigStorage payConfigStorage, HttpConfigStorage httpConfigStorage) {
        PayService payService = this.getPayService(payConfigStorage);
        payService.setRequestTemplateConfigStorage(httpConfigStorage);
        return payService;
    }

    public TransactionType getTransactionType(String name) {
        return PayoneerTransactionType.valueOf((String)name);
    }
}

