/*
 * Decompiled with CFR 0.152.
 */
package com.egzosn.pay.spring.boot.core.provider.merchant.platform;

import com.egzosn.pay.common.api.PayConfigStorage;
import com.egzosn.pay.common.api.PayService;
import com.egzosn.pay.common.bean.CertStoreType;
import com.egzosn.pay.common.bean.TransactionType;
import com.egzosn.pay.common.http.HttpConfigStorage;
import com.egzosn.pay.spring.boot.core.merchant.PaymentPlatform;
import com.egzosn.pay.spring.boot.core.merchant.bean.CommonPaymentPlatformMerchantDetails;
import com.egzosn.pay.union.api.UnionPayConfigStorage;
import com.egzosn.pay.union.api.UnionPayService;
import com.egzosn.pay.union.bean.UnionTransactionType;
import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.annotation.Configuration;

@Configuration(value="unionPay")
@ConditionalOnMissingBean(value={UnionPaymentPlatform.class})
@ConditionalOnClass(name={"com.egzosn.pay.union.api.UnionPayConfigStorage"})
public class UnionPaymentPlatform
implements PaymentPlatform {
    protected final Log LOG = LogFactory.getLog(UnionPaymentPlatform.class);
    public static final String PLATFORM_NAME = "unionPay";
    @Deprecated
    public static final String platformName = "unionPay";

    @Override
    public String getPlatform() {
        return "unionPay";
    }

    public PayService getPayService(PayConfigStorage payConfigStorage) {
        if (payConfigStorage instanceof UnionPayConfigStorage) {
            return new UnionPayService((UnionPayConfigStorage)payConfigStorage);
        }
        UnionPayConfigStorage configStorage = new UnionPayConfigStorage();
        configStorage.setMerId(payConfigStorage.getPid());
        configStorage.setCertSign(true);
        configStorage.setPid(payConfigStorage.getPid());
        configStorage.setNotifyUrl(payConfigStorage.getNotifyUrl());
        configStorage.setReturnUrl(payConfigStorage.getReturnUrl());
        configStorage.setSignType(payConfigStorage.getSignType());
        configStorage.setPayType(payConfigStorage.getPayType());
        configStorage.setInputCharset(payConfigStorage.getInputCharset());
        configStorage.setTest(payConfigStorage.isTest());
        if (payConfigStorage instanceof CommonPaymentPlatformMerchantDetails) {
            CommonPaymentPlatformMerchantDetails merchantDetails = (CommonPaymentPlatformMerchantDetails)payConfigStorage;
            configStorage.setCertStoreType(merchantDetails.getCertStoreType());
            try {
                configStorage.setAcpMiddleCert(merchantDetails.getKeyPublicCertInputStream());
                configStorage.setAcpRootCert(merchantDetails.getKeyCertInputStream());
                configStorage.setKeyPrivateCert(merchantDetails.getKeystoreInputStream());
                configStorage.setCertStoreType(CertStoreType.INPUT_STREAM);
            }
            catch (IOException e) {
                this.LOG.error((Object)e);
            }
            configStorage.setKeyPrivateCertPwd(merchantDetails.getKeystorePwd());
        }
        return new UnionPayService(configStorage);
    }

    public PayService getPayService(PayConfigStorage payConfigStorage, HttpConfigStorage httpConfigStorage) {
        PayService payService = this.getPayService(payConfigStorage);
        payService.setRequestTemplateConfigStorage(httpConfigStorage);
        return payService;
    }

    public TransactionType getTransactionType(String name) {
        return UnionTransactionType.valueOf((String)name);
    }
}

