/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.advertisement.service.impl;

import com.els.base.advertisement.dao.AdBannerCtrMapper;
import com.els.base.advertisement.entity.AdBannerCtr;
import com.els.base.advertisement.entity.AdBannerCtrExample;
import com.els.base.advertisement.service.AdBannerCtrService;
import com.els.base.core.entity.PageView;
import com.els.base.core.utils.Assert;
import com.els.base.utils.uuid.UUIDGenerator;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="defaultAdBannerCtrService")
public class AdBannerCtrServiceImpl
implements AdBannerCtrService {
    @Resource
    protected AdBannerCtrMapper adBannerCtrMapper;

    @CacheEvict(value={"adBannerCtr"}, allEntries=true)
    public void addObj(AdBannerCtr t) {
        this.adBannerCtrMapper.insertSelective(t);
    }

    @Transactional
    @CacheEvict(value={"adBannerCtr"}, allEntries=true)
    public void addAll(List<AdBannerCtr> list) {
        if (CollectionUtils.isEmpty(list)) {
            return;
        }
        list.stream().forEach(item -> {
            if (StringUtils.isBlank((String)item.getId())) {
                item.setId(UUIDGenerator.generateUUID());
            }
        });
        this.adBannerCtrMapper.insertBatch(list);
    }

    @CacheEvict(value={"adBannerCtr"}, allEntries=true)
    public void deleteObjById(String id) {
        this.adBannerCtrMapper.deleteByPrimaryKey(id);
    }

    @CacheEvict(value={"adBannerCtr"}, allEntries=true)
    public void deleteByExample(AdBannerCtrExample example) {
        Assert.isNotNull((Object)example, (String)"\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isNotEmpty(example.getOredCriteria(), (String)"\u6279\u91cf\u5220\u9664\u4e0d\u80fd\u5168\u8868\u5220\u9664");
        this.adBannerCtrMapper.deleteByExample(example);
    }

    @CacheEvict(value={"adBannerCtr"}, allEntries=true)
    public void modifyObj(AdBannerCtr t) {
        Assert.isNotBlank((String)t.getId(), (String)"id \u4e3a\u7a7a\uff0c\u65e0\u6cd5\u4fee\u6539");
        this.adBannerCtrMapper.updateByPrimaryKeySelective(t);
    }

    @Cacheable(value={"adBannerCtr"}, keyGenerator="redisKeyGenerator")
    public AdBannerCtr queryObjById(String id) {
        return this.adBannerCtrMapper.selectByPrimaryKey(id);
    }

    @Cacheable(value={"adBannerCtr"}, keyGenerator="redisKeyGenerator")
    public List<AdBannerCtr> queryAllObjByExample(AdBannerCtrExample example) {
        return this.adBannerCtrMapper.selectByExample(example);
    }

    @Cacheable(value={"adBannerCtr"}, keyGenerator="redisKeyGenerator")
    public PageView<AdBannerCtr> queryObjByPage(AdBannerCtrExample example) {
        PageView<AdBannerCtr> pageView = example.getPageView();
        pageView.setQueryResult(this.adBannerCtrMapper.selectByExampleByPage(example));
        return pageView;
    }

    @Override
    @CacheEvict(value={"adBannerCtr"}, allEntries=true)
    public void increaseCtr(AdBannerCtr ctr) {
        Assert.isNotBlank((String)ctr.getAdBannerId(), (String)"\u8f6e\u64ad\u56feid\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isNotBlank((String)ctr.getUserId(), (String)"\u7528\u6237\u4e0d\u80fd\u4e3a\u7a7a");
        AdBannerCtrExample example = new AdBannerCtrExample();
        example.createCriteria().andAdBannerIdEqualTo(ctr.getAdBannerId()).andUserIdEqualTo(ctr.getUserId());
        int count = this.adBannerCtrMapper.countByExample(example);
        if (count == 0) {
            ctr.setClickRate(1);
            this.adBannerCtrMapper.insertSelective(ctr);
        } else {
            this.adBannerCtrMapper.increaseClickRate(ctr.getAdBannerId(), ctr.getUserId(), new Date());
        }
    }
}

