/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.advertisement.web.controller;

import com.els.base.advertisement.entity.AdBanner;
import com.els.base.advertisement.entity.AdBannerExample;
import com.els.base.advertisement.service.AdBannerService;
import com.els.base.auth.utils.SpringSecurityUtils;
import com.els.base.core.entity.IExample;
import com.els.base.core.entity.PageView;
import com.els.base.core.entity.ResponseResult;
import com.els.base.core.utils.Assert;
import com.els.base.core.utils.Constant;
import com.els.base.core.utils.CriteriaUtils;
import com.els.base.core.utils.query.QueryParamWapper;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Api(value="\u5f39\u7a97\u5e7f\u544a\u8f6e\u64ad\u56fe")
@Controller
@RequestMapping(value={"adBanner"})
public class AdBannerController {
    @Resource
    protected AdBannerService adBannerService;

    @ApiOperation(httpMethod="POST", value="\u521b\u5efa\u5f39\u7a97\u5e7f\u544a\u8f6e\u64ad\u56fe")
    @RequestMapping(value={"service/create"})
    @ResponseBody
    public ResponseResult<String> create(@RequestBody AdBanner adBanner) {
        Assert.isNotNull((Object)adBanner);
        Assert.isNotBlank((String)adBanner.getTitle(), (String)"\u6807\u9898\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isNotBlank((String)adBanner.getImgUrl(), (String)"\u8f6e\u64ad\u56fe\u4e0d\u80fd\u4e3a\u7a7a");
        adBanner.setCreateUserId(SpringSecurityUtils.getLoginUserId());
        adBanner.setCreateUserName(SpringSecurityUtils.getLoginUser().getNickName());
        adBanner.setCreateTime(new Date());
        if (adBanner.getIsEnable() == null) {
            adBanner.setIsEnable(Constant.NO_INT);
        }
        if (adBanner.getSortNo() == null) {
            adBanner.setSortNo(Constant.NO_INT);
        }
        this.adBannerService.addObj(adBanner);
        return ResponseResult.success((Object)adBanner.getId());
    }

    @ApiOperation(httpMethod="POST", value="\u7f16\u8f91\u5f39\u7a97\u5e7f\u544a\u8f6e\u64ad\u56fe")
    @RequestMapping(value={"service/edit"})
    @ResponseBody
    public ResponseResult<String> edit(@RequestBody AdBanner adBanner) {
        Assert.isNotBlank((String)adBanner.getId(), (String)"id \u4e3a\u7a7a\uff0c\u4fdd\u5b58\u5931\u8d25");
        this.adBannerService.modifyObj(adBanner);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u542f\u7528\u6216\u7981\u7528\u5e7f\u544a\u8f6e\u64ad\u56fe")
    @RequestMapping(value={"service/setIsEnable"})
    @ResponseBody
    public ResponseResult<String> setIsEnableByIds(Integer isEnable, @RequestBody(required=true) List<String> ids) {
        Assert.isNotEmpty(ids, (String)"\u5220\u9664\u5931\u8d25,id\u4e0d\u80fd\u4e3a\u7a7a");
        AdBannerExample example = new AdBannerExample();
        example.createCriteria().andIdIn((List)ids);
        this.adBannerService.setIsEnableByIds(ids, isEnable);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u5220\u9664\u5f39\u7a97\u5e7f\u544a\u8f6e\u64ad\u56fe")
    @RequestMapping(value={"service/deleteByIds"})
    @ResponseBody
    public ResponseResult<String> deleteByIds(@RequestBody(required=true) List<String> ids) {
        Assert.isNotEmpty(ids, (String)"\u5220\u9664\u5931\u8d25,id\u4e0d\u80fd\u4e3a\u7a7a");
        AdBannerExample example = new AdBannerExample();
        example.createCriteria().andIdIn((List)ids);
        this.adBannerService.deleteByExample((IExample)example);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u67e5\u8be2\u6240\u6709\u542f\u7528\u7684\u5f39\u7a97\u5e7f\u544a\u8f6e\u64ad\u56fe")
    @RequestMapping(value={"service/findAllEnable"})
    @ResponseBody
    public ResponseResult<List<AdBanner>> findAllEnable() {
        AdBannerExample example = new AdBannerExample();
        example.setOrderByClause("SORT_NO DESC");
        example.createCriteria().andIsEnableEqualTo(Constant.YES_INT);
        List list = this.adBannerService.queryAllObjByExample((IExample)example);
        return ResponseResult.success((Object)list);
    }

    @ApiOperation(httpMethod="POST", value="\u67e5\u8be2\u5f39\u7a97\u5e7f\u544a\u8f6e\u64ad\u56fe")
    @ApiImplicitParams(value={@ApiImplicitParam(name="pageNo", required=false, value="\u6240\u5728\u9875", paramType="query", dataType="String", defaultValue="0"), @ApiImplicitParam(name="pageSize", required=false, value="\u6bcf\u9875\u6570\u91cf", paramType="query", dataType="String", defaultValue="10"), @ApiImplicitParam(name="wapper", required=false, value="\u67e5\u8be2\u6761\u4ef6,\u5c5e\u6027\u540d\u8bf7\u53c2\u8003 AdBanner", paramType="body", dataType="QueryParamWapper")})
    @RequestMapping(value={"service/findByPage"})
    @ResponseBody
    public ResponseResult<PageView<AdBanner>> findByPage(@RequestParam(defaultValue="0") int pageNo, @RequestParam(defaultValue="10") int pageSize, @RequestBody(required=false) QueryParamWapper wapper) {
        AdBannerExample example = new AdBannerExample();
        example.setPageView((PageView<AdBanner>)new PageView(pageNo, pageSize));
        AdBannerExample.Criteria criteria = example.createCriteria();
        if (wapper != null) {
            CriteriaUtils.addExample((IExample)example, (QueryParamWapper)wapper);
        }
        PageView pageData = this.adBannerService.queryObjByPage((IExample)example);
        return ResponseResult.success((Object)pageData);
    }
}

