/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.advertisement.web.controller;

import com.els.base.advertisement.entity.AdBanner;
import com.els.base.advertisement.entity.AdBannerCtr;
import com.els.base.advertisement.entity.AdBannerCtrExample;
import com.els.base.advertisement.service.AdBannerCtrService;
import com.els.base.advertisement.service.AdBannerService;
import com.els.base.auth.entity.User;
import com.els.base.core.entity.IExample;
import com.els.base.core.entity.ResponseResult;
import com.els.base.core.utils.Assert;
import com.els.base.utils.SpringContextHolder;
import com.els.base.utils.reflect.ReflectUtils;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.lang.reflect.InvocationTargetException;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContext;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Api(value="\u5f39\u7a97\u8f6e\u64ad\u56fe\u70b9\u51fb\u7387")
@Controller
@RequestMapping(value={"adBannerCtr"})
public class AdBannerCtrController {
    private static final Logger logger = LoggerFactory.getLogger(AdBannerCtrController.class);
    @Resource
    protected AdBannerCtrService adBannerCtrService;
    @Resource
    protected AdBannerService adBannerService;

    @ApiOperation(httpMethod="POST", value="\u67e5\u8be2\u5f39\u7a97\u8f6e\u64ad\u56fe\u70b9\u51fb\u7387")
    @RequestMapping(value={"service/findAll"})
    @ResponseBody
    public ResponseResult<List<AdBannerCtr>> findAll() {
        return ResponseResult.success((Object)this.adBannerCtrService.queryAllObjByExample((IExample)new AdBannerCtrExample()));
    }

    @ApiOperation(httpMethod="POST", value="\u70b9\u51fb\u7387\u7edf\u8ba1")
    @RequestMapping(value={"front/record"})
    @ResponseBody
    public ResponseResult<String> record(String adBannerId, HttpServletRequest request, HttpServletResponse response) {
        Object obj;
        Authentication authentication;
        Assert.isNotBlank((String)adBannerId, (String)"id\u4e0d\u80fd\u4e3a\u7a7a");
        AdBanner banner = (AdBanner)this.adBannerService.queryObjById(adBannerId);
        Assert.isNotNull((Object)banner, (String)"\u8f6e\u64ad\u56fe\u4e0d\u5b58\u5728");
        AdBannerCtr ctr = new AdBannerCtr();
        ctr.setAdBannerId(adBannerId);
        ctr.setAdBannerTitle(banner.getTitle());
        ctr.setLastClickTime(new Date());
        SecurityContext context = (SecurityContext)request.getSession().getAttribute("SPRING_SECURITY_CONTEXT");
        if (context != null && (authentication = context.getAuthentication()) != null && (obj = authentication.getPrincipal()) != null && obj instanceof User) {
            User user = (User)obj;
            ctr.setUserId(user.getId());
            ctr.setUserName(user.getNickName());
            ctr.setUserPhone(user.getMobilePhone());
        }
        try {
            this.completeCompanyInfo(ctr);
        }
        catch (Exception e) {
            logger.warn("\u8865\u5145\u516c\u53f8\u4fe1\u606f\u9519\u8bef", (Throwable)e);
        }
        this.adBannerCtrService.increaseCtr(ctr);
        return ResponseResult.success();
    }

    private void completeCompanyInfo(AdBannerCtr ctr) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException, ClassNotFoundException {
        Object userRefService = SpringContextHolder.getOneBean(Class.forName("com.els.base.company.service.CompanyUserRefService"));
        Object companyService = SpringContextHolder.getOneBean(Class.forName("com.els.base.company.service.CompanyService"));
        if (userRefService == null) {
            return;
        }
        if (companyService == null) {
            return;
        }
        String companyId = (String)ReflectUtils.invokeMethod((Object)userRefService, (String)"queryCompanyIdOfUser", (Object[])new Object[]{ctr.getUserId()});
        if (StringUtils.isBlank((String)companyId)) {
            return;
        }
        Object company = ReflectUtils.invokeMethod((Object)companyService, (String)"queryObjById", (Object[])new Object[]{companyId});
        if (company == null) {
            return;
        }
        ctr.setCompanyId(companyId);
        ctr.setCompanyName((String)ReflectUtils.getValue((Object)company, (String)"companyFullName"));
        ctr.setCompanySrmCode((String)ReflectUtils.getValue((Object)company, (String)"companyCode"));
    }
}

