/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.advertisement.service.impl;

import com.els.base.advertisement.dao.AdBannerMapper;
import com.els.base.advertisement.entity.AdBanner;
import com.els.base.advertisement.entity.AdBannerExample;
import com.els.base.advertisement.service.AdBannerService;
import com.els.base.core.entity.PageView;
import com.els.base.core.utils.Assert;
import com.els.base.core.utils.Constant;
import com.els.base.utils.uuid.UUIDGenerator;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="defaultAdBannerService")
public class AdBannerServiceImpl
implements AdBannerService {
    @Resource
    protected AdBannerMapper adBannerMapper;

    @CacheEvict(value={"adBanner"}, allEntries=true)
    public void addObj(AdBanner t) {
        this.adBannerMapper.insertSelective(t);
    }

    @Transactional
    @CacheEvict(value={"adBanner"}, allEntries=true)
    public void addAll(List<AdBanner> list) {
        if (CollectionUtils.isEmpty(list)) {
            return;
        }
        list.stream().forEach(item -> {
            if (StringUtils.isBlank((String)item.getId())) {
                item.setId(UUIDGenerator.generateUUID());
            }
        });
        this.adBannerMapper.insertBatch(list);
    }

    @CacheEvict(value={"adBanner"}, allEntries=true)
    public void deleteObjById(String id) {
        this.adBannerMapper.deleteByPrimaryKey(id);
    }

    @CacheEvict(value={"adBanner"}, allEntries=true)
    public void deleteByExample(AdBannerExample example) {
        Assert.isNotNull((Object)example, (String)"\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isNotEmpty(example.getOredCriteria(), (String)"\u6279\u91cf\u5220\u9664\u4e0d\u80fd\u5168\u8868\u5220\u9664");
        this.adBannerMapper.deleteByExample(example);
    }

    @CacheEvict(value={"adBanner"}, allEntries=true)
    public void modifyObj(AdBanner t) {
        Assert.isNotBlank((String)t.getId(), (String)"id \u4e3a\u7a7a\uff0c\u65e0\u6cd5\u4fee\u6539");
        this.adBannerMapper.updateByPrimaryKeySelective(t);
    }

    @Cacheable(value={"adBanner"}, keyGenerator="redisKeyGenerator")
    public AdBanner queryObjById(String id) {
        return this.adBannerMapper.selectByPrimaryKey(id);
    }

    @Cacheable(value={"adBanner"}, keyGenerator="redisKeyGenerator")
    public List<AdBanner> queryAllObjByExample(AdBannerExample example) {
        return this.adBannerMapper.selectByExample(example);
    }

    @Cacheable(value={"adBanner"}, keyGenerator="redisKeyGenerator")
    public PageView<AdBanner> queryObjByPage(AdBannerExample example) {
        PageView<AdBanner> pageView = example.getPageView();
        pageView.setQueryResult(this.adBannerMapper.selectByExampleByPage(example));
        return pageView;
    }

    @Override
    @CacheEvict(value={"adBanner"}, allEntries=true)
    public void setIsEnableByIds(List<String> ids, Integer isEnable) {
        Assert.isNotEmpty(ids, (String)"\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a");
        if (!Constant.YES_INT.equals(isEnable)) {
            isEnable = Constant.NO_INT;
        }
        AdBannerExample example = new AdBannerExample();
        example.createCriteria().andIdIn((List)ids);
        AdBanner record = new AdBanner();
        record.setIsEnable(isEnable);
        this.adBannerMapper.updateByExampleSelective(record, example);
    }
}

