package com.els.base.advertisement.service.impl;

import java.util.Date;
import java.util.List;

import javax.annotation.Resource;

import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.els.base.advertisement.dao.AdBannerCtrMapper;
import com.els.base.advertisement.entity.AdBannerCtr;
import com.els.base.advertisement.entity.AdBannerCtrExample;
import com.els.base.advertisement.service.AdBannerCtrService;
import com.els.base.core.entity.PageView;
import com.els.base.core.utils.Assert;
import com.els.base.utils.uuid.UUIDGenerator;

@Service("defaultAdBannerCtrService")
public class AdBannerCtrServiceImpl implements AdBannerCtrService {
    @Resource
    protected AdBannerCtrMapper adBannerCtrMapper;

    @CacheEvict(value={"adBannerCtr"}, allEntries=true)
    @Override
    public void addObj(AdBannerCtr t) {
        this.adBannerCtrMapper.insertSelective(t);
    }

    @Transactional
    @CacheEvict(value={"adBannerCtr"}, allEntries=true)
    @Override
    public void addAll(List<AdBannerCtr> list) {
        if (CollectionUtils.isEmpty(list)) {
            return;
        }
        list.stream().forEach(item->{
            if (StringUtils.isBlank(item.getId())) {
                item.setId(UUIDGenerator.generateUUID());
            }
        });
        this.adBannerCtrMapper.insertBatch(list);
    }

    @CacheEvict(value={"adBannerCtr"}, allEntries=true)
    @Override
    public void deleteObjById(String id) {
        this.adBannerCtrMapper.deleteByPrimaryKey(id);
    }

    @CacheEvict(value={"adBannerCtr"}, allEntries=true)
    @Override
    public void deleteByExample(AdBannerCtrExample example) {
        Assert.isNotNull(example, "参数不能为空");
        Assert.isNotEmpty(example.getOredCriteria(), "批量删除不能全表删除");
        this.adBannerCtrMapper.deleteByExample(example);
    }

    @CacheEvict(value={"adBannerCtr"}, allEntries=true)
    @Override
    public void modifyObj(AdBannerCtr t) {
        Assert.isNotBlank(t.getId(), "id 为空，无法修改");
        this.adBannerCtrMapper.updateByPrimaryKeySelective(t);
    }

    @Cacheable(value="adBannerCtr", keyGenerator="redisKeyGenerator")
    @Override
    public AdBannerCtr queryObjById(String id) {
        return this.adBannerCtrMapper.selectByPrimaryKey(id);
    }

    @Cacheable(value="adBannerCtr", keyGenerator="redisKeyGenerator")
    @Override
    public List<AdBannerCtr> queryAllObjByExample(AdBannerCtrExample example) {
        return this.adBannerCtrMapper.selectByExample(example);
    }

    @Cacheable(value="adBannerCtr", keyGenerator="redisKeyGenerator")
    @Override
    public PageView<AdBannerCtr> queryObjByPage(AdBannerCtrExample example) {
        PageView<AdBannerCtr> pageView = example.getPageView();
        pageView.setQueryResult(this.adBannerCtrMapper.selectByExampleByPage(example));
        return pageView;
    }

    @CacheEvict(value={"adBannerCtr"}, allEntries=true)
	@Override
	public void increaseCtr(AdBannerCtr ctr) {
		Assert.isNotBlank(ctr.getAdBannerId(), "轮播图id不能为空");
		Assert.isNotBlank(ctr.getUserId(), "用户不能为空");
		
		AdBannerCtrExample example = new AdBannerCtrExample();
		example.createCriteria().andAdBannerIdEqualTo(ctr.getAdBannerId())
			.andUserIdEqualTo(ctr.getUserId());
		
		int count = this.adBannerCtrMapper.countByExample(example);
		if (count == 0) {
			ctr.setClickRate(1);
			this.adBannerCtrMapper.insertSelective(ctr);
		}else {
			this.adBannerCtrMapper.increaseClickRate(ctr.getAdBannerId(), ctr.getUserId(), new Date());
		}
		
	}

}