package com.els.base.advertisement.service.impl;

import java.util.List;

import javax.annotation.Resource;

import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.els.base.advertisement.dao.AdBannerMapper;
import com.els.base.advertisement.entity.AdBanner;
import com.els.base.advertisement.entity.AdBannerExample;
import com.els.base.advertisement.service.AdBannerService;
import com.els.base.core.entity.PageView;
import com.els.base.core.utils.Assert;
import com.els.base.core.utils.Constant;
import com.els.base.utils.uuid.UUIDGenerator;

@Service("defaultAdBannerService")
public class AdBannerServiceImpl implements AdBannerService {
    @Resource
    protected AdBannerMapper adBannerMapper;

    @CacheEvict(value={"adBanner"}, allEntries=true)
    @Override
    public void addObj(AdBanner t) {
        this.adBannerMapper.insertSelective(t);
    }

    @Transactional
    @CacheEvict(value={"adBanner"}, allEntries=true)
//    @Override
    public void addAll(List<AdBanner> list) {
        if (CollectionUtils.isEmpty(list)) {
            return;
        }
        list.stream().forEach(item->{
            if (StringUtils.isBlank(item.getId())) {
                item.setId(UUIDGenerator.generateUUID());
            }
        });
        this.adBannerMapper.insertBatch(list);
    }

    @CacheEvict(value={"adBanner"}, allEntries=true)
    @Override
    public void deleteObjById(String id) {
        this.adBannerMapper.deleteByPrimaryKey(id);
    }

    @CacheEvict(value={"adBanner"}, allEntries=true)
//    @Override
    public void deleteByExample(AdBannerExample example) {
        Assert.isNotNull(example, "参数不能为空");
        Assert.isNotEmpty(example.getOredCriteria(), "批量删除不能全表删除");
        this.adBannerMapper.deleteByExample(example);
    }

    @CacheEvict(value={"adBanner"}, allEntries=true)
    @Override
    public void modifyObj(AdBanner t) {
        Assert.isNotBlank(t.getId(), "id 为空，无法修改");
        this.adBannerMapper.updateByPrimaryKeySelective(t);
    }

    @Cacheable(value="adBanner", keyGenerator="redisKeyGenerator")
    @Override
    public AdBanner queryObjById(String id) {
        return this.adBannerMapper.selectByPrimaryKey(id);
    }

    @Cacheable(value="adBanner", keyGenerator="redisKeyGenerator")
    @Override
    public List<AdBanner> queryAllObjByExample(AdBannerExample example) {
        return this.adBannerMapper.selectByExample(example);
    }

    @Cacheable(value="adBanner", keyGenerator="redisKeyGenerator")
    @Override
    public PageView<AdBanner> queryObjByPage(AdBannerExample example) {
        PageView<AdBanner> pageView = example.getPageView();
        pageView.setQueryResult(this.adBannerMapper.selectByExampleByPage(example));
        return pageView;
    }

    @CacheEvict(value={"adBanner"}, allEntries=true)
	@Override
	public void setIsEnableByIds(List<String> ids, Integer isEnable) {
    	Assert.isNotEmpty(ids, "数据不能为空");
    	
    	if (!Constant.YES_INT.equals(isEnable)) {
			isEnable = Constant.NO_INT;
		}
    	
		AdBannerExample example = new AdBannerExample();
		example.createCriteria()
			.andIdIn(ids);
		
		AdBanner record = new AdBanner();
		record.setIsEnable(isEnable);
		this.adBannerMapper.updateByExampleSelective(record, example);
		
//		AdBannerExample example = new AdBannerExample();
//		example.createCriteria()
//			.andIdIn(ids)
//			.andIsEnableEqualTo(Constant.YES_INT);
//		
//		int enableCount = this.adBannerMapper.countByExample(example);
//		if (enableCount > 0) {
//			// disable all
//			AdBanner banner = new AdBanner();
//			banner.setIsEnable(Constant.NO_INT);
//			this.adBannerMapper.updateByExampleSelective(banner, example);
//			
//		}else {
//			example.clear();
//			example.createCriteria().andIdIn(ids);
//			
//			AdBanner banner = new AdBanner();
//			banner.setIsEnable(Constant.YES_INT);
//			this.adBannerMapper.updateByExampleSelective(banner, example);
//		}
	}
}