package com.els.base.advertisement.web.controller;

import java.util.Date;
import java.util.List;

import javax.annotation.Resource;

import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

import com.els.base.advertisement.entity.AdBanner;
import com.els.base.advertisement.entity.AdBannerExample;
import com.els.base.advertisement.service.AdBannerService;
import com.els.base.auth.utils.SpringSecurityUtils;
import com.els.base.core.entity.PageView;
import com.els.base.core.entity.ResponseResult;
import com.els.base.core.utils.Assert;
import com.els.base.core.utils.Constant;
import com.els.base.core.utils.CriteriaUtils;
import com.els.base.core.utils.query.QueryParamWapper;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;

@Api(value="弹窗广告轮播图")
@Controller
@RequestMapping("adBanner")
public class AdBannerController {
    @Resource
    protected AdBannerService adBannerService;

    @ApiOperation(httpMethod="POST", value="创建弹窗广告轮播图")
    @RequestMapping("service/create")
    @ResponseBody
    public ResponseResult<String> create(@RequestBody AdBanner adBanner) {
    	Assert.isNotNull(adBanner);
    	Assert.isNotBlank(adBanner.getTitle(), "标题不能为空");
    	Assert.isNotBlank(adBanner.getImgUrl(), "轮播图不能为空");
    	

    	adBanner.setCreateUserId(SpringSecurityUtils.getLoginUserId());
    	adBanner.setCreateUserName(SpringSecurityUtils.getLoginUser().getNickName());
    	adBanner.setCreateTime(new Date());
    	
    	if (adBanner.getIsEnable() == null) {
			adBanner.setIsEnable(Constant.NO_INT);
		}
    	
    	if (adBanner.getSortNo() == null) {
			adBanner.setSortNo(Constant.NO_INT);
		}
    	
        this.adBannerService.addObj(adBanner);
        return ResponseResult.success(adBanner.getId());
    }

    @ApiOperation(httpMethod="POST", value="编辑弹窗广告轮播图")
    @RequestMapping("service/edit")
    @ResponseBody
    public ResponseResult<String> edit(@RequestBody AdBanner adBanner) {
        Assert.isNotBlank(adBanner.getId(), "id 为空，保存失败");
        
        this.adBannerService.modifyObj(adBanner);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="启用或禁用广告轮播图")
    @RequestMapping("service/setIsEnable")
    @ResponseBody
    public ResponseResult<String> setIsEnableByIds(Integer isEnable, @RequestBody(required=true) List<String> ids) {
    	Assert.isNotEmpty(ids, "删除失败,id不能为空");
    	
    	AdBannerExample example = new AdBannerExample();
    	example.createCriteria().andIdIn(ids);
    	
    	this.adBannerService.setIsEnableByIds(ids, isEnable);
    	return ResponseResult.success();
    }
    
    @ApiOperation(httpMethod="POST", value="删除弹窗广告轮播图")
    @RequestMapping("service/deleteByIds")
    @ResponseBody
    public ResponseResult<String> deleteByIds(@RequestBody(required=true) List<String> ids) {
        Assert.isNotEmpty(ids, "删除失败,id不能为空");
        AdBannerExample example = new AdBannerExample();
        example.createCriteria().andIdIn(ids);
        this.adBannerService.deleteByExample(example);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="查询所有启用的弹窗广告轮播图")
    @RequestMapping("service/findAllEnable")
    @ResponseBody
    public ResponseResult<List<AdBanner>> findAllEnable() {
    	AdBannerExample example = new AdBannerExample();
    	example.setOrderByClause("SORT_NO DESC");
    	example.createCriteria().andIsEnableEqualTo(Constant.YES_INT);
    	
    	List<AdBanner> list = this.adBannerService.queryAllObjByExample(example);
    	return ResponseResult.success(list);
    }
    
    
    
    @ApiOperation(httpMethod="POST", value="查询弹窗广告轮播图")
    @ApiImplicitParams({ 
		@ApiImplicitParam( name = "pageNo",required = false,value = "所在页", paramType = "query", dataType = "String", defaultValue = "0" ),  
		@ApiImplicitParam( name = "pageSize", required = false, value = "每页数量", paramType = "query", dataType = "String", defaultValue = "10" ),  
		@ApiImplicitParam( name = "wapper", required = false, value = "查询条件,属性名请参考 AdBanner", paramType = "body", dataType = "QueryParamWapper" )  
	}) 
    @RequestMapping("service/findByPage")
    @ResponseBody
    public ResponseResult<PageView<AdBanner>> findByPage( 
		@RequestParam(defaultValue="0") int pageNo,  
		@RequestParam(defaultValue="10") int pageSize, 
		@RequestBody(required=false) QueryParamWapper wapper) {
        AdBannerExample example = new AdBannerExample();
        example.setPageView(new PageView<AdBanner>(pageNo, pageSize));
        
        AdBannerExample.Criteria criteria = example.createCriteria();
        //填写具体的查询条件，例如
        //criteria.andIdEqualTo("1");
        if (wapper != null) {
            CriteriaUtils.addExample(example, wapper);
        }
        
        PageView<AdBanner> pageData = this.adBannerService.queryObjByPage(example);
        return ResponseResult.success(pageData);
    }
}