package com.els.base.advertisement.web.controller;

import java.lang.reflect.InvocationTargetException;
import java.util.Date;
import java.util.List;

import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContext;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

import com.els.base.advertisement.entity.AdBanner;
import com.els.base.advertisement.entity.AdBannerCtr;
import com.els.base.advertisement.entity.AdBannerCtrExample;
import com.els.base.advertisement.service.AdBannerCtrService;
import com.els.base.advertisement.service.AdBannerService;
import com.els.base.auth.entity.User;
import com.els.base.core.entity.ResponseResult;
import com.els.base.core.utils.Assert;
import com.els.base.utils.SpringContextHolder;
import com.els.base.utils.reflect.ReflectUtils;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;

@Api(value = "弹窗轮播图点击率")
@Controller
@RequestMapping("adBannerCtr")
public class AdBannerCtrController {
	
	private static final Logger logger = LoggerFactory.getLogger(AdBannerCtrController.class);
	
	@Resource
	protected AdBannerCtrService adBannerCtrService;
	
	@Resource
	protected AdBannerService adBannerService;

	@ApiOperation(httpMethod = "POST", value = "查询弹窗轮播图点击率")
	@RequestMapping("service/findAll")
	@ResponseBody
	public ResponseResult<List<AdBannerCtr>> findAll() {
		return ResponseResult.success(this.adBannerCtrService.queryAllObjByExample(new AdBannerCtrExample()));
	}

	@ApiOperation(httpMethod = "POST", value = "点击率统计")
	@RequestMapping(value = "front/record")
	@ResponseBody
	public ResponseResult<String> record(String adBannerId, HttpServletRequest request, HttpServletResponse response) {
		
		Assert.isNotBlank(adBannerId, "id不能为空");
		
		AdBanner banner = adBannerService.queryObjById(adBannerId);
		Assert.isNotNull(banner, "轮播图不存在");
		
		
		AdBannerCtr ctr = new AdBannerCtr();
		ctr.setAdBannerId(adBannerId);
		ctr.setAdBannerTitle(banner.getTitle());
		ctr.setLastClickTime(new Date());
		
		
		SecurityContext context = (SecurityContext) request.getSession().getAttribute("SPRING_SECURITY_CONTEXT");
		if (context != null) {
			Authentication authentication = context.getAuthentication();
	        if (authentication != null) {
		        Object obj = authentication.getPrincipal();
		        if (obj!=null &&  obj instanceof User) {
		            User user = (User) obj;
		            ctr.setUserId(user.getId());
		            ctr.setUserName(user.getNickName());
		            ctr.setUserPhone(user.getMobilePhone());
		        }
	        }
		}
		
		try {
			this.completeCompanyInfo(ctr);
			
		} catch (Exception e) {
			logger.warn("补充公司信息错误", e);
		}
		
		this.adBannerCtrService.increaseCtr(ctr);
		return ResponseResult.success();
	}

	private void completeCompanyInfo(AdBannerCtr ctr) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException, ClassNotFoundException {
		
		Object userRefService = SpringContextHolder.getOneBean(Class.forName("com.els.base.company.service.CompanyUserRefService"));
		Object companyService = SpringContextHolder.getOneBean(Class.forName("com.els.base.company.service.CompanyService"));
		
		if (userRefService == null) {
			return;
		}
		
		if (companyService == null) {
			return;
		}
		
		String companyId = (String) ReflectUtils.invokeMethod(userRefService, "queryCompanyIdOfUser", ctr.getUserId());
		if (StringUtils.isBlank(companyId)) {
			return;
		}
		
		Object company = ReflectUtils.invokeMethod(companyService, "queryObjById", companyId);
		if (company == null) {
			return;
		}
		
		ctr.setCompanyId(companyId);
		ctr.setCompanyName((String) ReflectUtils.getValue(company, "companyFullName"));
		ctr.setCompanySrmCode((String) ReflectUtils.getValue(company, "companyCode"));
	}
}