/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.auth.utils;

import java.util.ArrayList;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.security.web.util.matcher.AntPathRequestMatcher;
import org.springframework.security.web.util.matcher.RequestMatcher;

public class AnonymousMatcherUtils {
    private static List<RequestMatcher> anonymousMatchers = new ArrayList<RequestMatcher>();

    public static void configAnonymousMatchers(String ... antPatterns) {
        for (String pattern : antPatterns) {
            anonymousMatchers.add((RequestMatcher)new AntPathRequestMatcher(pattern));
        }
    }

    public static List<RequestMatcher> getAnonymousMatchers() {
        return anonymousMatchers;
    }

    public static boolean isAnonymousAccess(HttpServletRequest request) {
        if (CollectionUtils.isEmpty(AnonymousMatcherUtils.getAnonymousMatchers())) {
            return false;
        }
        return AnonymousMatcherUtils.getAnonymousMatchers().stream().anyMatch(matcher -> matcher.matches(request));
    }

    private AnonymousMatcherUtils() {
    }
}

