/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.auth.web.controller;

import com.els.base.auth.service.RoleService;
import com.els.base.auth.utils.SpringSecurityUtils;
import com.els.base.core.entity.ResponseResult;
import com.els.base.core.entity.user.User;
import com.els.base.core.exception.CommonException;
import com.els.base.core.service.user.UserService;
import com.els.base.core.utils.Assert;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import javax.servlet.http.HttpSession;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Api(value="\u6743\u9650\u7ba1\u7406-\u767b\u5f55\u5e10\u53f7\u7ba1\u7406")
@Controller(value="authUserController")
@RequestMapping(value={"user"})
public class UserController {
    @Autowired
    private UserService userService;
    @Autowired
    protected RoleService roleService;
    @Autowired
    protected AuthenticationManager authenticationManager;

    @ApiOperation(value="\u67e5\u8be2\u5f53\u524d\u7528\u6237", httpMethod="GET")
    @RequestMapping(value={"service/findCurrentUser"})
    @ResponseBody
    public ResponseResult<User> findCurrentUser() {
        User user = SpringSecurityUtils.getLoginUser();
        return ResponseResult.success((Object)user);
    }

    @ApiOperation(value="\u4fee\u6539\u5f53\u524d\u7528\u6237\u7684\u5bc6\u7801", httpMethod="POST")
    @RequestMapping(value={"service/modifyUserPwd"})
    @ResponseBody
    public ResponseResult<String> modifyUserPwd(@RequestParam(required=true) String oldPwd, @RequestParam(required=true) String newPwd) throws Exception {
        if (oldPwd.equals(newPwd)) {
            throw new CommonException("\u65b0\u65e7\u5bc6\u7801\u662f\u4e00\u6837\u7684\uff0c\u65e0\u9700\u4fee\u6539");
        }
        this.userService.modifyPwd(SpringSecurityUtils.getLoginUserId(), oldPwd, newPwd);
        return ResponseResult.success();
    }

    @ApiOperation(value="\u66f4\u6362\u624b\u673a\u53f7-\u53d1\u9001\u77ed\u4fe1\u9a8c\u8bc1\u7801")
    @RequestMapping(value={"/service/sendShortMsgVerifyCode"})
    @ResponseBody
    public ResponseResult<String> sendShortMsgVerifyCode(HttpSession session, @RequestParam(required=false) String currentPhone, @RequestParam(required=false) String currentPwd, @RequestParam(required=false) String newPhone) {
        Assert.isNotBlank((String)currentPhone, (String)"\u5f53\u524d\u624b\u673a\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isNotBlank((String)currentPwd, (String)"\u5f53\u524d\u5bc6\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isNotBlank((String)newPhone, (String)"\u65b0\u624b\u673a\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        User currentUser = SpringSecurityUtils.getLoginUser();
        if (!currentPhone.equals(currentUser.getMobilePhone())) {
            throw new CommonException("\u5f53\u524d\u624b\u673a\u53f7\u7801\u4e0d\u6b63\u786e");
        }
        if (!this.userService.checkPassword(currentUser.getId(), currentPwd)) {
            throw new CommonException("\u5f53\u524d\u5bc6\u7801\u4e0d\u6b63\u786e");
        }
        if (currentPhone.equals(newPhone)) {
            throw new CommonException("\u65b0\u624b\u673a\u53f7\u4e0d\u80fd\u4e0e\u5f53\u524d\u624b\u673a\u53f7\u76f8\u540c");
        }
        this.userService.queryByMobilePhone(newPhone).ifPresent(user -> {
            throw new CommonException("\u8be5\u624b\u673a\u53f7\u5df2\u88ab\u5b58\u5728");
        });
        int code = 123456;
        session.setAttribute("modify.phone.verify.code", (Object)Integer.toString(code));
        session.setAttribute("modify.phone.new.phone", (Object)newPhone);
        return ResponseResult.success();
    }

    @ApiOperation(value="\u66f4\u6362\u624b\u673a\u53f7-\u786e\u8ba4\u66f4\u6362\u624b\u673a\u53f7\u7801")
    @RequestMapping(value={"/service/modifyUserPhone"})
    @ResponseBody
    public ResponseResult<String> modifyUserPhone(HttpSession session, @RequestParam(required=false) String currentPhone, @RequestParam(required=false) String currentPwd, @RequestParam(required=false) String newPhone, @RequestParam(required=false) String verifyCode) {
        Assert.isNotBlank((String)currentPhone, (String)"\u5f53\u524d\u624b\u673a\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isNotBlank((String)currentPwd, (String)"\u5f53\u524d\u5bc6\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isNotBlank((String)newPhone, (String)"\u65b0\u624b\u673a\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isNotBlank((String)verifyCode, (String)"\u9a8c\u8bc1\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        User currentUser = SpringSecurityUtils.getLoginUser();
        if (!currentPhone.equals(currentUser.getMobilePhone())) {
            throw new CommonException("\u5f53\u524d\u624b\u673a\u53f7\u7801\u4e0d\u6b63\u786e");
        }
        if (!this.userService.checkPassword(currentUser.getId(), currentPwd)) {
            throw new CommonException("\u5f53\u524d\u5bc6\u7801\u4e0d\u6b63\u786e");
        }
        Object sessionVerifyCode = session.getAttribute("modify.phone.verify.code");
        Assert.isNotNull((Object)sessionVerifyCode, (String)"\u8bf7\u5148\u83b7\u53d6\u9a8c\u8bc1\u7801");
        if (!verifyCode.equals(sessionVerifyCode)) {
            throw new CommonException("\u9a8c\u8bc1\u7801\u4e0d\u6b63\u786e");
        }
        Object sessionNewPhone = session.getAttribute("modify.phone.new.phone");
        if (!newPhone.equals(sessionNewPhone)) {
            throw new CommonException("\u65b0\u624b\u673a\u53f7\u4e0e\u63a5\u6536\u9a8c\u8bc1\u7801\u7684\u624b\u673a\u53f7\u4e0d\u4e00\u81f4");
        }
        this.userService.updateMobilePhone(currentUser.getId(), newPhone);
        return ResponseResult.success();
    }
}

