/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.auth.service.impl;

import com.els.base.auth.dao.MenuMapper;
import com.els.base.auth.entity.Menu;
import com.els.base.auth.entity.MenuExample;
import com.els.base.auth.entity.OperatorExample;
import com.els.base.auth.entity.RoleRight;
import com.els.base.auth.entity.RoleRightExample;
import com.els.base.auth.service.ButtonService;
import com.els.base.auth.service.IMenuTipGenerator;
import com.els.base.auth.service.MenuService;
import com.els.base.auth.service.OperatorService;
import com.els.base.auth.service.RoleRightService;
import com.els.base.auth.utils.AuthConstant;
import com.els.base.auth.utils.MenuComparator;
import com.els.base.core.entity.IExample;
import com.els.base.core.entity.PageView;
import com.els.base.core.exception.CommonException;
import com.els.base.core.utils.Assert;
import com.els.base.utils.SpringContextHolder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class MenuServiceImpl
implements MenuService {
    private static final int MAX_CALLCOUNT = 5;
    @Resource
    private MenuMapper menuMapper;
    @Resource
    private RoleRightService roleRightService;
    @Resource
    private OperatorService operatorService;
    @Resource
    private ButtonService buttonService;

    @Transactional
    @CacheEvict(value={"menu"}, allEntries=true)
    public void addObj(Menu menu) {
        Assert.isNotNull((Object)menu, (String)"\u83dc\u5355\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isNotBlank((String)menu.getMenuCode(), (String)"\u83dc\u5355\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isNotBlank((String)menu.getMenuName(), (String)"\u83dc\u5355\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isNotBlank((String)menu.getMenuType(), (String)"\u83dc\u5355\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
        if (menu.getMenuCode().length() > 255) {
            throw new CommonException("\u83dc\u5355\u680f\u76ee\u4ee3\u7801\u957f\u5ea6\u4e0d\u80fd\u8d85\u8fc7255", "length_canot_exceed", new Object[]{"\u83dc\u5355\u680f\u76ee\u4ee3\u7801", "255"});
        }
        if (menu.getMenuName().length() > 255) {
            throw new CommonException("\u540d\u79f0\u957f\u5ea6\u4e0d\u80fd\u8d85\u8fc7100", "length_canot_exceed", new Object[]{"\u540d\u79f0", "255"});
        }
        MenuExample menuExample = new MenuExample();
        menuExample.createCriteria().andMenuCodeEqualTo(menu.getMenuCode());
        if (this.menuMapper.countByExample(menuExample) > 0) {
            throw new CommonException("\u83dc\u5355code\u503c\u5df2\u5b58\u5728", "base_is_exists", new Object[]{"code\u503c"});
        }
        this.menuMapper.insertSelective(menu);
    }

    @CacheEvict(value={"menu"}, allEntries=true)
    public void deleteObjById(String menuId) {
        this.deleteChildrenMenu(menuId, 0);
    }

    @Transactional
    @CacheEvict(value={"menu"}, allEntries=true)
    public void modifyObj(Menu menu) {
        Assert.isNotBlank((String)menu.getId(), (String)"\u83dc\u5355id\u4e0d\u80fd\u4e3a\u7a7a");
        if (menu.getMenuCode().length() > 255) {
            throw new CommonException("\u83dc\u5355\u680f\u76ee\u4ee3\u7801\u957f\u5ea6\u4e0d\u80fd\u8d85\u8fc7255", "length_canot_exceed", new Object[]{"\u83dc\u5355\u680f\u76ee\u4ee3\u7801", "255"});
        }
        if (menu.getMenuName().length() > 255) {
            throw new CommonException("\u540d\u79f0\u957f\u5ea6\u4e0d\u80fd\u8d85\u8fc7100", "length_canot_exceed", new Object[]{"\u540d\u79f0", "255"});
        }
        if (StringUtils.isNotBlank((String)menu.getMenuCode())) {
            MenuExample menuExample = new MenuExample();
            menuExample.createCriteria().andMenuCodeEqualTo(menu.getMenuCode()).andIdNotEqualTo(menu.getId());
            if (this.menuMapper.countByExample(menuExample) > 0) {
                throw new CommonException("\u83dc\u5355code\u503c\u5df2\u5b58\u5728", "base_is_exists", new Object[]{"code\u503c"});
            }
        }
        menu.setMenuType(null);
        this.menuMapper.updateByPrimaryKeySelective(menu);
    }

    @Cacheable(value={"menu"}, keyGenerator="redisKeyGenerator")
    public Menu queryObjById(String id) {
        return this.menuMapper.selectByPrimaryKey(id);
    }

    @Cacheable(value={"menu"}, keyGenerator="redisKeyGenerator")
    public List<Menu> queryAllObjByExample(MenuExample example) {
        return this.menuMapper.selectByExample(example);
    }

    @Cacheable(value={"menu"}, keyGenerator="redisKeyGenerator")
    public PageView<Menu> queryObjByPage(MenuExample example) {
        PageView<Menu> pageView = example.getPageView();
        List<Menu> list = this.menuMapper.selectByExampleByPage(example);
        pageView.setQueryResult(list);
        return pageView;
    }

    private void deleteChildrenMenu(String menuId, int callCount) {
        if (++callCount > 5) {
            return;
        }
        MenuExample menuExample = new MenuExample();
        menuExample.createCriteria().andParentIdEqualTo(menuId);
        menuExample.setOrderByClause("sort_no ASC");
        List<Menu> menuChildren = this.menuMapper.selectByExample(menuExample);
        for (Menu subMenu : menuChildren) {
            this.deleteChildrenMenu(subMenu.getId(), callCount);
        }
        this.menuMapper.deleteByPrimaryKey(menuId);
        OperatorExample operatorExample = new OperatorExample();
        operatorExample.createCriteria().andMenuIdEqualTo(menuId);
        this.operatorService.deleteByExample(operatorExample);
        this.buttonService.deleteObjByMenuId(menuId);
    }

    @Override
    @Cacheable(value={"menu"}, keyGenerator="redisKeyGenerator")
    public List<Menu> queryAllMenuWithAuthRoleIds(List<String> currentRoleIds, List<String> targetRoleIds, String menuType) {
        List<Menu> currentMenus;
        if (CollectionUtils.isEmpty(currentRoleIds)) {
            throw new CommonException("\u5f53\u524d\u7684\u89d2\u8272\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((String)menuType)) {
            throw new CommonException("\u83dc\u5355\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
        }
        MenuExample menuExample = new MenuExample();
        MenuExample.Criteria criteria = menuExample.createCriteria();
        criteria.andMenuTypeEqualTo(menuType);
        if (!currentRoleIds.contains(AuthConstant.SYS_MANAGER_ROLE.getId())) {
            List<String> currentMenuIds = this.queryMenuIdByRoleId(currentRoleIds, menuType);
            if (CollectionUtils.isEmpty(currentMenuIds)) {
                return null;
            }
            criteria.andIdIn((List)currentMenuIds);
        }
        if (CollectionUtils.isEmpty(currentMenus = this.queryAllObjByExample(menuExample))) {
            return null;
        }
        if (!targetRoleIds.contains(AuthConstant.SYS_MANAGER_ROLE.getId()) && !currentRoleIds.equals(targetRoleIds)) {
            List<String> targetMenuId = this.queryMenuIdByRoleId(targetRoleIds, menuType);
            for (Menu menu : currentMenus) {
                menu.setAuthorized(targetMenuId.contains(menu.getId()));
            }
        }
        ArrayList<Menu> allMenu = new ArrayList<Menu>();
        for (Menu menu : currentMenus) {
            if (!"1".equals(menu.getParentId())) continue;
            allMenu.add(menu);
            List<Menu> children = this.findChildren(menu, currentMenus);
            menu.setChildren(children);
        }
        Collections.sort(allMenu, new MenuComparator());
        this.buttonService.setAuthDataInMenu(currentMenus, currentRoleIds, targetRoleIds);
        this.operatorService.setAuthDataInMenu(currentMenus, currentRoleIds, targetRoleIds);
        return allMenu;
    }

    private List<Menu> findChildren(Menu parent, List<Menu> currentMenus) {
        ArrayList<Menu> allMenu = new ArrayList<Menu>();
        for (Menu child : currentMenus) {
            if (!parent.getId().equals(child.getParentId())) continue;
            allMenu.add(child);
            List<Menu> children = this.findChildren(child, currentMenus);
            child.setChildren(children);
        }
        Collections.sort(allMenu, new MenuComparator());
        return allMenu;
    }

    @Override
    @Cacheable(value={"menu"}, keyGenerator="redisKeyGenerator")
    public List<Menu> queryAuthedMenuForRoleIds(List<String> roleIds, String menuType) {
        return this.queryAllMenuWithAuthRoleIds(roleIds, roleIds, menuType);
    }

    private List<String> queryMenuIdByRoleId(List<String> roleIds, String menuType) {
        RoleRightExample roleRightExample = new RoleRightExample();
        roleRightExample.createCriteria().andRoleIdIn((List)roleIds).andTypeEqualTo(menuType);
        List roleRightList = this.roleRightService.queryAllObjByExample((IExample)roleRightExample);
        ArrayList<String> authMenuIds = new ArrayList<String>();
        for (RoleRight roleRight : roleRightList) {
            authMenuIds.add(roleRight.getKeyId());
        }
        return authMenuIds;
    }

    @CacheEvict(value={"menu"}, allEntries=true)
    public void deleteByExample(MenuExample example) {
        Assert.isNotNull((Object)example, (String)"\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isNotEmpty(example.getOredCriteria(), (String)"\u6279\u91cf\u5220\u9664\u4e0d\u80fd\u5168\u8868\u5220\u9664");
        this.menuMapper.deleteByExample(example);
    }

    @CacheEvict(value={"menu"}, allEntries=true)
    @Transactional
    public void addAll(List<Menu> list) {
        if (CollectionUtils.isEmpty(list)) {
            return;
        }
        list.forEach(record -> this.menuMapper.insertSelective((Menu)record));
    }

    @Override
    public List<Menu> queryMenuTip(List<String> roleIdList, String menuType) {
        List<Menu> menuList;
        if (CollectionUtils.isEmpty(roleIdList)) {
            return null;
        }
        Map beans = SpringContextHolder.getBeans(IMenuTipGenerator.class);
        if (MapUtils.isEmpty((Map)beans)) {
            return null;
        }
        List tipGenerators = beans.entrySet().stream().map(Map.Entry::getValue).collect(Collectors.toList());
        MenuExample menuExample = new MenuExample();
        MenuExample.Criteria criteria = menuExample.createCriteria();
        criteria.andMenuTypeEqualTo(menuType);
        if (!roleIdList.contains(AuthConstant.SYS_MANAGER_ROLE.getId())) {
            List<String> currentMenuIds = this.queryMenuIdByRoleId(roleIdList, menuType);
            if (CollectionUtils.isEmpty(currentMenuIds)) {
                return null;
            }
            criteria.andIdIn((List)currentMenuIds);
        }
        if (CollectionUtils.isEmpty(menuList = this.queryAllObjByExample(menuExample))) {
            return null;
        }
        tipGenerators.stream().sorted(Comparator.comparing(IMenuTipGenerator::getPriority).reversed()).forEach(tipGenerator -> menuList.stream().filter(menu -> tipGenerator.isMatchMenuCode(menu.getMenuCode())).forEach(menu -> menu.setTip(tipGenerator.generate((Menu)menu))));
        menuList.stream().filter(menu -> StringUtils.isNotBlank((String)menu.getTip()));
        return menuList;
    }
}

