/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.auth.service.impl;

import com.els.base.auth.dao.UserRoleMapper;
import com.els.base.auth.entity.Role;
import com.els.base.auth.entity.UserRole;
import com.els.base.auth.entity.UserRoleExample;
import com.els.base.auth.enumeration.RoleEnum;
import com.els.base.auth.service.RoleService;
import com.els.base.auth.service.UserRoleService;
import com.els.base.core.entity.PageView;
import com.els.base.core.entity.user.User;
import com.els.base.core.entity.user.UserExample;
import com.els.base.core.utils.Assert;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="userRoleService")
public class UserRoleServiceImpl
implements UserRoleService {
    @Autowired
    private UserRoleMapper userRoleMapper;
    @Autowired
    private RoleService roleService;

    @CacheEvict(value={"roleCache", "roleRightCache"}, allEntries=true)
    public void addObj(UserRole userRole) {
        Date date = new Date();
        userRole.setCreateTime(date);
        this.userRoleMapper.insertSelective(userRole);
    }

    @CacheEvict(value={"roleCache", "roleRightCache"}, allEntries=true)
    public void deleteObjById(String id) {
        this.userRoleMapper.deleteByPrimaryKey(id);
    }

    @CacheEvict(value={"roleCache", "roleRightCache"}, allEntries=true)
    public void modifyObj(UserRole userRole) {
        if (userRole == null || StringUtils.isBlank((String)userRole.getId())) {
            throw new IllegalArgumentException("id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        this.userRoleMapper.updateByPrimaryKeySelective(userRole);
    }

    @Override
    @Cacheable(value={"roleCache"}, keyGenerator="redisKeyGenerator")
    public List<UserRole> queryUserRoleList(String userId) {
        UserRoleExample example = new UserRoleExample();
        example.createCriteria().andUserIdEqualTo(userId);
        return this.queryAllObjByExample(example);
    }

    @Override
    @Cacheable(value={"roleCache"}, keyGenerator="redisKeyGenerator")
    public List<String> queryUserOwnRoleIds(String userId) {
        UserRoleExample example = new UserRoleExample();
        example.createCriteria().andUserIdEqualTo(userId);
        List<UserRole> list = this.userRoleMapper.selectByExample(example);
        ArrayList<String> ids = new ArrayList<String>();
        for (int i = 0; i < list.size(); ++i) {
            ids.add(list.get(i).getRoleId());
        }
        return ids;
    }

    @Override
    @CacheEvict(value={"roleCache", "roleRightCache"}, allEntries=true)
    public void deleteAllUserRole(String userId) {
        UserRoleExample example = new UserRoleExample();
        example.createCriteria().andUserIdEqualTo(userId);
        this.userRoleMapper.deleteByExample(example);
    }

    @Cacheable(value={"roleCache"}, keyGenerator="redisKeyGenerator")
    public UserRole queryObjById(String id) {
        return this.userRoleMapper.selectByPrimaryKey(id);
    }

    @Cacheable(value={"roleCache"}, keyGenerator="redisKeyGenerator")
    public List<UserRole> queryAllObjByExample(UserRoleExample example) {
        return this.userRoleMapper.selectByExample(example);
    }

    @Cacheable(value={"roleCache"}, keyGenerator="redisKeyGenerator")
    public PageView<UserRole> queryObjByPage(UserRoleExample example) {
        PageView<UserRole> pageView = example.getPageView();
        pageView.setQueryResult(this.userRoleMapper.selectByExampleByPage(example));
        return pageView;
    }

    @Override
    @Transactional
    @CacheEvict(value={"roleCache", "roleRightCache"}, allEntries=true)
    public void resetUserRole(String userId, String[] roleIds) {
        this.deleteAllUserRole(userId);
        for (String roleId : roleIds) {
            UserRole userRole = new UserRole();
            userRole.setUserId(userId);
            userRole.setRoleId(roleId);
            this.addObj(userRole);
        }
    }

    @Override
    @Cacheable(value={"roleCache"}, keyGenerator="redisKeyGenerator")
    public List<String> queryUserIdsForRoleId(String roleId) {
        UserRoleExample example = new UserRoleExample();
        example.createCriteria().andRoleIdEqualTo(roleId);
        List<UserRole> list = this.userRoleMapper.selectByExample(example);
        ArrayList<String> ids = new ArrayList<String>();
        for (int i = 0; i < list.size(); ++i) {
            ids.add(list.get(i).getUserId());
        }
        return ids;
    }

    @CacheEvict(value={"roleCache", "roleRightCache"}, allEntries=true)
    public void deleteByExample(UserRoleExample example) {
        Assert.isNotNull((Object)((Object)example), (String)"\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isNotEmpty(example.getOredCriteria(), (String)"\u6279\u91cf\u5220\u9664\u4e0d\u80fd\u5168\u8868\u5220\u9664");
        this.userRoleMapper.deleteByExample(example);
    }

    @CacheEvict(value={"roleCache", "roleRightCache"}, allEntries=true)
    @Transactional
    public void addAll(List<UserRole> list) {
        if (CollectionUtils.isEmpty(list)) {
            return;
        }
        list.forEach(record -> this.userRoleMapper.insertSelective((UserRole)record));
    }

    @Override
    @Cacheable(value={"roleCache"}, keyGenerator="redisKeyGenerator")
    public boolean hasRole(String userId, RoleEnum role) {
        return this.hasRole(userId, role.code());
    }

    @Override
    @Cacheable(value={"roleCache"}, keyGenerator="redisKeyGenerator")
    public boolean hasRole(String userId, String roleCode) {
        Role role = this.roleService.queryByRoleCode(roleCode).orElse(null);
        if (role != null) {
            UserRoleExample example = new UserRoleExample();
            example.or().andUserIdEqualTo(userId).andRoleIdEqualTo(role.getId());
            List<UserRole> list = this.queryAllObjByExample(example);
            return CollectionUtils.isNotEmpty(list);
        }
        return false;
    }

    @Override
    @Cacheable(value={"userService"}, keyGenerator="redisKeyGenerator")
    public PageView<User> queryUserHasRoleByPage(UserExample example, RoleEnum role) {
        return this.queryUserHasRoleByPage(example, role.code());
    }

    @Override
    @Cacheable(value={"userService"}, keyGenerator="redisKeyGenerator")
    public PageView<User> queryUserHasRoleByPage(UserExample example, String roleCode) {
        PageView pageView = example.getPageView();
        pageView.setQueryResult(this.userRoleMapper.queryUserHasRoleByPage(example, roleCode));
        return pageView;
    }
}

