/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.auth.web.security.impl;

import com.els.base.auth.exception.CaptchaErrorException;
import com.els.base.auth.exception.CaptchaNotFoundException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.web.authentication.UsernamePasswordAuthenticationFilter;
import org.springframework.util.ObjectUtils;

public class CustomCaptchaAuthenticationFilter
extends UsernamePasswordAuthenticationFilter {
    @Value(value="${auth.captcha.is.enable:true}")
    private String isEnable;

    public Authentication attemptAuthentication(HttpServletRequest request, HttpServletResponse response) throws AuthenticationException {
        if (!"true".equals(this.isEnable)) {
            return super.attemptAuthentication(request, response);
        }
        String captcha = this.obtainCaptcha(request);
        Object sessionCaptcha = request.getSession().getAttribute("captcha");
        if (StringUtils.isBlank((CharSequence)captcha)) {
            throw new CaptchaNotFoundException("\u8bf7\u8f93\u5165\u9a8c\u8bc1\u7801");
        }
        if (ObjectUtils.isEmpty((Object)sessionCaptcha)) {
            throw new CaptchaNotFoundException("\u9a8c\u8bc1\u7801\u5df2\u8fc7\u671f\uff0c\u8bf7\u70b9\u51fb\u9a8c\u8bc1\u7801\u91cd\u65b0\u83b7\u53d6");
        }
        if (!this.verifyCaptcha(captcha, sessionCaptcha.toString())) {
            throw new CaptchaErrorException("\u9a8c\u8bc1\u7801\u9519\u8bef");
        }
        return super.attemptAuthentication(request, response);
    }

    protected String obtainCaptcha(HttpServletRequest request) {
        return request.getParameter("captcha");
    }

    public boolean verifyCaptcha(String captcha, String sessionCaptcha) {
        return captcha.equalsIgnoreCase(sessionCaptcha);
    }
}

