/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.auth.web.security.impl;

import com.els.base.auth.entity.AuthUser;
import com.els.base.core.entity.IExample;
import com.els.base.core.entity.ResponseResult;
import com.els.base.core.entity.project.Project;
import com.els.base.core.entity.project.ProjectExample;
import com.els.base.core.service.project.ProjectService;
import com.els.base.utils.http.HttpResponseUtils;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import javax.annotation.Resource;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.security.core.Authentication;
import org.springframework.security.web.authentication.logout.SimpleUrlLogoutSuccessHandler;
import org.springframework.stereotype.Component;

@Component(value="customLogoutSuccessHandler")
public class CustomLogoutSuccessHandler
extends SimpleUrlLogoutSuccessHandler {
    @Resource
    private ProjectService projectService;

    public CustomLogoutSuccessHandler() {
        this.setDefaultTargetUrl("/login.html");
    }

    public void onLogoutSuccess(HttpServletRequest request, HttpServletResponse response, Authentication authentication) throws IOException, ServletException {
        Project project;
        if (authentication == null) {
            HttpResponseUtils.responseResutlAsJson((HttpServletResponse)response, (Object)ResponseResult.success(null));
            return;
        }
        AuthUser user = (AuthUser)((Object)authentication.getPrincipal());
        if (user == null) {
            HttpResponseUtils.responseResutlAsJson((HttpServletResponse)response, (Object)ResponseResult.success(null));
            return;
        }
        ProjectExample projectExample = new ProjectExample();
        projectExample.createCriteria().andProjectCodeEqualTo(user.getProjectCode());
        List projectList = this.projectService.queryAllObjByExample((IExample)projectExample);
        String logoutPage = null;
        if (CollectionUtils.isNotEmpty((Collection)projectList) && (project = (Project)projectList.get(0)) != null) {
            logoutPage = project.getLogoutSuccessPage();
        }
        HttpResponseUtils.responseResutlAsJson((HttpServletResponse)response, (Object)ResponseResult.success(logoutPage));
    }
}

