/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.auth.web.controller;

import com.els.base.auth.entity.Menu;
import com.els.base.auth.service.MenuService;
import com.els.base.auth.service.RoleRightService;
import com.els.base.auth.utils.SpringSecurityUtils;
import com.els.base.core.entity.ResponseResult;
import com.els.base.core.utils.Assert;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Api(value="\u6743\u9650\u7ba1\u7406-\u83dc\u5355\u7ba1\u7406")
@Controller
@RequestMapping(value={"menu"})
public class MenuController {
    @Autowired
    private MenuService menuService;
    @Resource
    private RoleRightService roleRightService;

    @ApiOperation(value="\u6dfb\u52a0\u83dc\u5355", httpMethod="POST")
    @RequestMapping(value={"service/addMenu"})
    @ResponseBody
    public ResponseResult<String> addMenu(@RequestBody Menu menu) {
        menu.setId(null);
        menu.setCreateTime(new Date());
        this.menuService.addObj(menu);
        return ResponseResult.success();
    }

    @ApiOperation(value="\u6839\u636eid\u5220\u9664\u83dc\u5355", httpMethod="GET")
    @RequestMapping(value={"service/deleteMenu"})
    @ResponseBody
    public ResponseResult<String> deleteMenu(@RequestParam(required=true) String menuId) {
        Assert.isNotBlank((String)menuId, (String)"\u83dc\u5355ID\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        this.menuService.deleteObjById(menuId);
        return ResponseResult.success();
    }

    @ApiOperation(value="\u4fee\u6539\u83dc\u5355", httpMethod="POST")
    @RequestMapping(value={"service/modifyMenu"})
    @ResponseBody
    public ResponseResult<String> modifyMenu(@RequestBody Menu menu) {
        Assert.isNotBlank((String)menu.getId(), (String)"\u83dc\u5355ID\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        menu.setUpdateTime(new Date());
        this.menuService.modifyObj(menu);
        return ResponseResult.success();
    }

    @ApiOperation(value="\u67e5\u8be2\u6240\u6709\u7684\u83dc\u5355", httpMethod="GET")
    @RequestMapping(value={"service/queryAllMenuTree"})
    @ResponseBody
    public ResponseResult<List<Menu>> queryAllMenuTree(String menuType) {
        if (StringUtils.isBlank((String)menuType)) {
            menuType = "menu";
        }
        List<Menu> list = this.menuService.queryAuthedMenuForRoleIds(SpringSecurityUtils.getLoginUserRoleIdList(), menuType);
        return ResponseResult.success(list);
    }

    @ApiOperation(value="\u67e5\u8be2\u83dc\u5355\u6811(\u5e26\u4e0a\u6743\u9650\u6807\u8bb0)", httpMethod="GET")
    @RequestMapping(value={"service/queryMenuTreeData"})
    @ResponseBody
    public ResponseResult<List<Menu>> queryMenuTreeData(@RequestParam(required=true) String roleId, String menuType) {
        if (StringUtils.isBlank((String)menuType)) {
            menuType = "menu";
        }
        List<Menu> list = this.menuService.queryAllMenuWithAuthRoleIds(SpringSecurityUtils.getLoginUserRoleIdList(), Arrays.asList(roleId), menuType);
        return ResponseResult.success(list);
    }

    @ApiOperation(value="\u67e5\u8be2\u5f53\u524d\u7528\u6237\u7684\u83dc\u5355\u6811", httpMethod="GET")
    @RequestMapping(value={"service/queryMenuForCurrentUser"})
    @ResponseBody
    public ResponseResult<List<Menu>> queryMenuForCurrentUser(String menuType) {
        if (StringUtils.isBlank((String)menuType)) {
            menuType = "menu";
        }
        List<String> roleId = SpringSecurityUtils.getLoginUserRoleIdList();
        List<Menu> list = this.menuService.queryAuthedMenuForRoleIds(roleId, menuType);
        return ResponseResult.success(list);
    }

    @ApiOperation(value="\u67e5\u8be2\u5f53\u524d\u7528\u6237\u7684\u83dc\u5355\u6811", httpMethod="GET")
    @RequestMapping(value={"service/queryMenuTipForCurrentUser"})
    @ResponseBody
    public ResponseResult<List<Menu>> queryMenuTipForCurrentUser(String menuType) {
        if (StringUtils.isBlank((String)menuType)) {
            menuType = "menu";
        }
        List<String> roleId = SpringSecurityUtils.getLoginUserRoleIdList();
        List<Menu> list = this.menuService.queryMenuTip(roleId, menuType);
        return ResponseResult.success(list);
    }
}

