/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.auth.web.controller;

import com.els.base.auth.entity.Role;
import com.els.base.auth.entity.RoleRight;
import com.els.base.auth.service.RoleRightService;
import com.els.base.auth.service.RoleService;
import com.els.base.auth.utils.SpringSecurityUtils;
import com.els.base.core.entity.ResponseResult;
import com.els.base.core.exception.CommonException;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"roleRight"})
public class RightController {
    @Resource
    private RoleRightService rightService;
    @Resource
    private RoleService roleService;

    @ApiOperation(value="\u5bf9\u89d2\u8272\u6388\u6743\u6216\u53d6\u6d88\u6388\u6743", httpMethod="POST")
    @RequestMapping(value={"service/authorizedOperator"})
    @ResponseBody
    public ResponseResult<String> authorizedOperator(@ApiParam(value="\u89d2\u8272id") @RequestParam String roleId, @RequestBody List<RoleRight> rights) {
        Role role = (Role)this.roleService.queryObjById(roleId);
        if (role == null) {
            throw new CommonException("\u8be5\u6570\u636e\u4e0d\u5b58\u5728", "do_not_exists", new Object[]{"\u89d2\u8272\u6570\u636e"});
        }
        if (Role.ROLE_LEVEL_SYS.equals(role.getRoleLevel()) && !SpringSecurityUtils.isManagerLoginUser()) {
            throw new CommonException("\u8be5\u89d2\u8272\u662f\u7cfb\u7edf\u89d2\u8272\u65e0\u6cd5\u4fee\u6539", "can_not_delete_sys_role");
        }
        this.rightService.authorized(roleId, rights);
        return ResponseResult.success();
    }
}

