/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.auth.utils;

import com.els.base.auth.entity.AuthUser;
import com.els.base.auth.entity.Role;
import com.els.base.auth.entity.RoleExample;
import com.els.base.auth.service.RoleService;
import com.els.base.core.entity.IExample;
import com.els.base.core.entity.user.User;
import com.els.base.utils.SpringContextHolder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.context.SecurityContextHolder;

public class SpringSecurityUtils {
    public static String getLoginUserId() {
        User user = SpringSecurityUtils.getLoginUser();
        if (user == null) {
            return null;
        }
        return user.getId();
    }

    public static User getLoginUser() {
        Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
        if (authentication == null) {
            return null;
        }
        Object obj = authentication.getPrincipal();
        if (obj != null && obj instanceof AuthUser) {
            return (AuthUser)((Object)obj);
        }
        return null;
    }

    public static String getLoginUserName() {
        AuthUser user;
        String loginName = null;
        Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
        Object obj = authentication.getPrincipal();
        if (obj instanceof AuthUser && (user = (AuthUser)((Object)obj)) != null) {
            loginName = user.getLoginName();
        }
        return loginName;
    }

    public static List<String> getLoginUserRoleIdList() {
        ArrayList<String> roleIds = new ArrayList<String>();
        Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
        Collection authorities = authentication.getAuthorities();
        for (GrantedAuthority authority : authorities) {
            roleIds.add(authority.getAuthority());
        }
        return roleIds;
    }

    public static List<Role> getLoginUserRoleList() {
        ArrayList<String> roleIds = new ArrayList<String>();
        Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
        Collection authorities = authentication.getAuthorities();
        for (GrantedAuthority authority : authorities) {
            roleIds.add(authority.getAuthority());
        }
        if (CollectionUtils.isEmpty(roleIds)) {
            return null;
        }
        RoleExample roleExample = new RoleExample();
        roleExample.createCriteria().andIdIn(roleIds);
        return ((RoleService)SpringContextHolder.getOneBean(RoleService.class)).queryAllObjByExample((IExample)roleExample);
    }

    public static boolean isManagerLoginUser() {
        return "admin".equals(SpringSecurityUtils.getLoginUserName());
    }
}

