/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.auth.web.controller;

import com.alibaba.fastjson.JSON;
import com.els.base.auth.enumeration.RoleEnum;
import com.els.base.auth.service.UserRoleService;
import com.els.base.auth.utils.NationUtils;
import com.els.base.auth.utils.SpringSecurityUtils;
import com.els.base.codegenerator.service.GenerateCodeService;
import com.els.base.core.entity.IExample;
import com.els.base.core.entity.PageView;
import com.els.base.core.entity.ResponseResult;
import com.els.base.core.entity.user.User;
import com.els.base.core.entity.user.UserExample;
import com.els.base.core.enumerate.UserTypeEnum;
import com.els.base.core.exception.CommonException;
import com.els.base.core.service.user.UserService;
import com.els.base.core.utils.Assert;
import com.els.base.core.utils.CriteriaUtils;
import com.els.base.core.utils.ObjectUtils;
import com.els.base.core.utils.query.QueryParamWapper;
import com.els.base.core.vo.EmailCodeInfo;
import com.els.base.core.vo.VerifyCode;
import com.els.base.utils.encryption.DESUtils;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import javax.servlet.http.HttpSession;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Api(value="\u6743\u9650\u7ba1\u7406-\u767b\u5f55\u5e10\u53f7\u7ba1\u7406")
@Controller(value="authUserController")
@RequestMapping(value={"user"})
public class UserController {
    private static final Logger logger = LoggerFactory.getLogger(UserController.class);
    @Autowired
    private UserService userService;
    @Autowired
    private UserRoleService userRoleService;
    @Autowired
    private GenerateCodeService generateCodeService;

    @ApiOperation(value="\u67e5\u8be2\u5f53\u524d\u7528\u6237", httpMethod="GET")
    @RequestMapping(value={"service/findCurrentUser"})
    @ResponseBody
    public ResponseResult<User> findCurrentUser() {
        User user = SpringSecurityUtils.getLoginUser();
        return ResponseResult.success((Object)user);
    }

    @ApiOperation(value="\u4fee\u6539\u5f53\u524d\u7528\u6237\u7684\u5bc6\u7801", httpMethod="POST")
    @RequestMapping(value={"service/modifyUserPwd"})
    @ResponseBody
    public ResponseResult<String> modifyUserPwd(String oldPwd, String newPwd, String passwordStrength) throws Exception {
        Assert.isNotBlank((String)oldPwd, (String)"\u65e7\u5bc6\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isNotBlank((String)newPwd, (String)"\u65b0\u5bc6\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        if (oldPwd.equals(newPwd)) {
            throw new CommonException("\u65b0\u65e7\u5bc6\u7801\u662f\u4e00\u6837\u7684\uff0c\u65e0\u9700\u4fee\u6539");
        }
        this.userService.modifyPwd(SpringSecurityUtils.getLoginUserId(), oldPwd, newPwd);
        SpringSecurityUtils.getLoginUser().setPasswordStrength(passwordStrength);
        return ResponseResult.success();
    }

    @ApiOperation(value="\u66f4\u6362\u624b\u673a\u53f7-\u786e\u8ba4\u66f4\u6362\u624b\u673a\u53f7\u7801", httpMethod="POST")
    @RequestMapping(value={"/service/modifyUserPhone"})
    @ResponseBody
    public ResponseResult<String> modifyUserPhone(HttpSession session, String currentPhone, String currentPwd, String newPhone, String verifyCode) {
        User currentUser = SpringSecurityUtils.getLoginUser();
        if (StringUtils.isNotBlank((String)currentUser.getMobilePhone())) {
            Assert.isNotBlank((String)currentPhone, (String)"\u5f53\u524d\u624b\u673a\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
            Assert.isNotBlank((String)currentPwd, (String)"\u5f53\u524d\u5bc6\u7801\u4e0d\u80fd\u4e3a\u7a7a");
            if (!currentPhone.equals(currentUser.getMobilePhone())) {
                throw new CommonException("\u5f53\u524d\u624b\u673a\u53f7\u7801\u4e0d\u6b63\u786e");
            }
            if (!this.userService.checkPassword(currentUser.getId(), currentPwd)) {
                throw new CommonException("\u5f53\u524d\u5bc6\u7801\u4e0d\u6b63\u786e");
            }
        }
        Assert.isNotBlank((String)newPhone, (String)"\u65b0\u624b\u673a\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isNotBlank((String)verifyCode, (String)"\u9a8c\u8bc1\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        this.validateSessionMobile(session, newPhone, "modify.phone.new.phone");
        this.validateSessionVerifyCode(session, verifyCode, "modify.phone.sms.verify.code");
        this.userService.updateMobilePhone(currentUser.getId(), newPhone);
        SpringSecurityUtils.getLoginUser().setMobilePhone(newPhone);
        return ResponseResult.success();
    }

    @ApiOperation(value="\u63d0\u4ea4\u8ba4\u8bc1", httpMethod="POST")
    @RequestMapping(value={"/front/submitAuth"})
    @ResponseBody
    public ResponseResult<String> submitAuth(@RequestBody(required=false) User authInfo) {
        this.validateAuthInfo(authInfo);
        authInfo.setPassword((String)ObjectUtils.firstNotBlank((CharSequence[])new String[]{authInfo.getPassword(), "123456"}));
        this.userService.submitAuth(authInfo);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u67e5\u8be2\u5f85\u8ba4\u8bc1\u7528\u6237\u5217\u8868\u9875")
    @RequestMapping(value={"service/findWaitForAuthByPage"})
    @ResponseBody
    public ResponseResult<PageView<User>> findWaitForAuthByPage(@RequestParam(defaultValue="0") int pageNo, @RequestParam(defaultValue="10") int pageSize, @RequestBody(required=false) QueryParamWapper wapper) {
        UserExample example = new UserExample();
        example.setPageView(new PageView(pageNo, pageSize));
        example.setOrderByClause("CREATE_TIME ASC");
        UserExample.Criteria criteria = example.createCriteria();
        criteria.andAuthStatusEqualTo(Integer.valueOf(0));
        if (wapper != null) {
            CriteriaUtils.addExample((IExample)example, (QueryParamWapper)wapper);
        }
        PageView pageData = null;
        String currentUserId = SpringSecurityUtils.getLoginUserId();
        if (this.userRoleService.hasRole(currentUserId, RoleEnum.INLAND_SALES_MANAGEMENT)) {
            criteria.andUserTypeEqualTo(Integer.valueOf(UserTypeEnum.ORDER_USER.type())).andNationIdEqualTo("China");
            pageData = this.userService.queryObjByPage((IExample)example);
        } else if (this.userRoleService.hasRole(currentUserId, RoleEnum.OUTLAND_SALES_MANAGEMENT)) {
            criteria.andUserTypeEqualTo(Integer.valueOf(UserTypeEnum.ORDER_USER.type())).andNationIdNotEqualTo("China");
            pageData = this.userService.queryObjByPage((IExample)example);
        } else if (this.userRoleService.hasRole(currentUserId, RoleEnum.INLAND_MARKET_MANAGEMENT)) {
            criteria.andUserTypeEqualTo(Integer.valueOf(UserTypeEnum.DATA_USER.type())).andNationIdEqualTo("China");
            pageData = this.userService.queryObjByPage((IExample)example);
        } else if (this.userRoleService.hasRole(currentUserId, RoleEnum.OUTLAND_MARKET_MANAGEMENT)) {
            criteria.andUserTypeEqualTo(Integer.valueOf(UserTypeEnum.DATA_USER.type())).andNationIdNotEqualTo("China");
            pageData = this.userService.queryObjByPage((IExample)example);
        } else {
            pageData = PageView.empty();
        }
        return ResponseResult.success((Object)pageData);
    }

    @ApiOperation(value="\u8ba4\u8bc1\u901a\u8fc7", httpMethod="GET")
    @RequestMapping(value={"/service/authPass"})
    @ResponseBody
    public ResponseResult<String> authPass(String id) {
        Assert.isNotBlank((String)id, (String)"id\u4e0d\u80fd\u4e3a\u7a7a");
        this.userService.authPass(id);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u67e5\u8be2\u5df2\u8ba4\u8bc1\u7528\u6237\u5217\u8868\u9875")
    @RequestMapping(value={"service/findAuthenticatedByPage"})
    @ResponseBody
    public ResponseResult<PageView<User>> findAuthenticatedByPage(@RequestParam(defaultValue="0") int pageNo, @RequestParam(defaultValue="10") int pageSize, @RequestParam(required=false) String tag, @RequestBody(required=false) QueryParamWapper wapper) {
        UserExample example = new UserExample();
        example.setPageView(new PageView(pageNo, pageSize));
        example.setOrderByClause("CREATE_TIME DESC");
        UserExample.Criteria criteria = example.createCriteria();
        criteria.andAuthStatusEqualTo(Integer.valueOf(1));
        if (wapper != null) {
            CriteriaUtils.addExample((IExample)example, (QueryParamWapper)wapper);
        }
        PageView<User> pageData = null;
        String currentUserId = SpringSecurityUtils.getLoginUserId();
        if (this.userRoleService.hasRole(currentUserId, RoleEnum.INLAND_SALES_MANAGEMENT)) {
            criteria.andNationIdEqualTo("China");
            pageData = this.userRoleService.queryUserHasRoleByPage(example, RoleEnum.ORDER_USER, tag);
        } else if (this.userRoleService.hasRole(currentUserId, RoleEnum.OUTLAND_SALES_MANAGEMENT)) {
            criteria.andNationIdNotEqualTo("China");
            pageData = this.userRoleService.queryUserHasRoleByPage(example, RoleEnum.ORDER_USER, tag);
        } else if (this.userRoleService.hasRole(currentUserId, RoleEnum.INLAND_MARKET_MANAGEMENT)) {
            criteria.andNationIdEqualTo("China");
            pageData = this.userRoleService.queryUserHasRoleByPage(example, RoleEnum.DATA_USER, tag);
        } else if (this.userRoleService.hasRole(currentUserId, RoleEnum.OUTLAND_MARKET_MANAGEMENT)) {
            criteria.andNationIdNotEqualTo("China");
            pageData = this.userRoleService.queryUserHasRoleByPage(example, RoleEnum.DATA_USER, tag);
        } else {
            pageData = PageView.empty();
        }
        return ResponseResult.success(pageData);
    }

    @ApiOperation(httpMethod="POST", value="\u67e5\u8be2\u8d1f\u8d23\u4eba\u5217\u8868")
    @RequestMapping(value={"service/findManagerByPage"})
    @ResponseBody
    public ResponseResult<PageView<User>> findManagerByPage(@RequestParam(defaultValue="0") int pageNo, @RequestParam(defaultValue="10") int pageSize, @RequestBody(required=false) QueryParamWapper wapper) {
        UserExample example = new UserExample();
        example.setPageView(new PageView(pageNo, pageSize));
        example.setOrderByClause("CREATE_TIME DESC");
        UserExample.Criteria criteria = example.createCriteria();
        criteria.andAuthStatusEqualTo(Integer.valueOf(1));
        if (wapper != null) {
            CriteriaUtils.addExample((IExample)example, (QueryParamWapper)wapper);
        }
        PageView<User> pageData = null;
        String currentUserId = SpringSecurityUtils.getLoginUserId();
        pageData = this.userRoleService.hasRole(currentUserId, RoleEnum.INLAND_SALES_MANAGEMENT) ? this.userRoleService.queryUserHasRoleByPage(example, RoleEnum.INLAND_SALES_MANAGER, null) : (this.userRoleService.hasRole(currentUserId, RoleEnum.OUTLAND_SALES_MANAGEMENT) ? this.userRoleService.queryUserHasRoleByPage(example, RoleEnum.OUTLAND_SALES_MANAGER, null) : PageView.empty());
        return ResponseResult.success((Object)pageData);
    }

    @ApiOperation(httpMethod="POST", value="\u5c06managerId\u8bbe\u4e3auserId\u7684\u8d1f\u8d23\u4eba")
    @RequestMapping(value={"service/setAsManager"})
    @ResponseBody
    public ResponseResult<String> setAsManager(String userId, String managerId) {
        Assert.isNotBlank((String)userId, (String)"userId\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isNotBlank((String)managerId, (String)"managerId\u4e0d\u80fd\u4e3a\u7a7a");
        this.userService.setAsManager(userId, managerId);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u67e5\u8be2\u6307\u5b9a\u89d2\u8272\u7684\u7528\u6237\u5217\u8868")
    @RequestMapping(value={"service/findUserWithRoleByPage"})
    @ResponseBody
    public ResponseResult<PageView<User>> findUserWithRoleByPage(@RequestParam(defaultValue="0") int pageNo, @RequestParam(defaultValue="10") int pageSize, @RequestBody(required=false) QueryParamWapper wapper, RoleEnum role) {
        Assert.isNotNull((Object)((Object)role), (String)"\u8981\u67e5\u8be2\u7684\u89d2\u8272\u4e0d\u80fd\u4e3a\u7a7a");
        UserExample example = new UserExample();
        example.setPageView(new PageView(pageNo, pageSize));
        example.setOrderByClause("CREATE_TIME DESC");
        UserExample.Criteria criteria = example.createCriteria();
        criteria.andAuthStatusEqualTo(Integer.valueOf(1));
        if (wapper != null) {
            CriteriaUtils.addExample((IExample)example, (QueryParamWapper)wapper);
        }
        PageView<User> pageData = this.userRoleService.queryUserHasRoleByPage(example, role, null);
        return ResponseResult.success(pageData);
    }

    @ApiOperation(httpMethod="POST", value="\u901a\u8fc7\u90ae\u7bb1\u627e\u56de\u5bc6\u7801")
    @RequestMapping(value={"front/updatePasswordByEmailCode"})
    @ResponseBody
    public ResponseResult<String> updatePasswordByEmailCode(String code, String password) {
        Assert.isNotBlank((String)code, (String)"code\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isNotBlank((String)password, (String)"\u65b0\u5bc6\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        String json = null;
        try {
            json = DESUtils.decrypt((String)code);
        }
        catch (Exception e) {
            logger.error("\u89e3\u7801\u5931\u8d25", (Throwable)e);
            throw new CommonException("\u65e0\u6548\u7684code");
        }
        EmailCodeInfo codeInfo = (EmailCodeInfo)JSON.parseObject((String)json, EmailCodeInfo.class);
        if (codeInfo.expired()) {
            throw new CommonException("\u9a8c\u8bc1\u94fe\u63a5\u5df2\u8fc7\u671f,\u8bf7\u91cd\u65b0\u83b7\u53d6");
        }
        try {
            this.userService.updatePwd(password, codeInfo.getUserId());
        }
        catch (Exception e) {
            logger.error("\u66f4\u65b0\u5bc6\u7801\u5931\u8d25", (Throwable)e);
            throw new CommonException("\u66f4\u65b0\u5bc6\u7801\u5931\u8d25,\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458");
        }
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="GET", value="\u68c0\u67e5\u624b\u673a\u53f7\u662f\u5426\u5b58\u5728")
    @RequestMapping(value={"front/checkMobile"})
    @ResponseBody
    public ResponseResult<String> checkMobile(String mobile) {
        Assert.isNotBlank((String)mobile, (String)"\u624b\u673a\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        this.userService.queryByMobilePhone(mobile).orElseThrow(() -> new CommonException("\u5e10\u53f7\u4e0d\u5b58\u5728"));
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="GET", value="\u6821\u9a8c\u627e\u56de\u5bc6\u7801\u7684\u9a8c\u8bc1\u7801\u662f\u5426\u6b63\u786e")
    @RequestMapping(value={"front/validateRetrievePasswordVerifyCode"})
    @ResponseBody
    public ResponseResult<String> validateRetrievePasswordVerifyCode(HttpSession session, String verifyCode) {
        this.validateSessionVerifyCode(session, verifyCode, "forget.password.sms.verify.code");
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="GET", value="\u627e\u56de\u5bc6\u7801-\u8bbe\u7f6e\u65b0\u5bc6\u7801")
    @RequestMapping(value={"front/updatePassword4RetrievePassword"})
    @ResponseBody
    public ResponseResult<String> updatePassword4RetrievePassword(HttpSession session, String mobile, String verifyCode, String password) {
        Assert.isNotBlank((String)mobile, (String)"\u624b\u673a\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isNotBlank((String)verifyCode, (String)"\u9a8c\u8bc1\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isNotBlank((String)password, (String)"\u65b0\u5bc6\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        User user = (User)this.userService.queryByMobilePhone(mobile).orElseThrow(() -> new CommonException("\u5e10\u53f7\u4e0d\u5b58\u5728"));
        this.validateSessionMobile(session, mobile, "forget.password.phone");
        this.validateSessionVerifyCode(session, verifyCode, "forget.password.sms.verify.code");
        try {
            this.userService.updatePwd(password, user.getId());
        }
        catch (Exception e) {
            logger.error("\u66f4\u65b0\u5bc6\u7801\u5931\u8d25", (Throwable)e);
            throw new CommonException("\u66f4\u65b0\u5bc6\u7801\u5931\u8d25,\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458");
        }
        return ResponseResult.success();
    }

    private void validateAuthInfo(User authInfo) {
        Assert.isNotNull((Object)authInfo, (String)"\u7528\u6237\u8ba4\u8bc1\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isNotNull((Object)authInfo.getUserType(), (String)"\u7528\u6237\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
        String loginName = null;
        while (this.userService.findByUserLoginName(loginName = this.generateCodeService.getNextCode("USER_ACCOUNT")) != null) {
        }
        authInfo.setLoginName(loginName);
        Assert.isNotBlank((String)authInfo.getNickName(), (String)"\u7528\u6237\u59d3\u540d\u4e0d\u80fd\u4e3a\u7a7a");
        String email = authInfo.getEmail();
        Assert.isNotBlank((String)email, (String)"\u7528\u6237\u90ae\u7bb1\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isNull(this.userService.queryByEmail(email).orElse(null), (String)("\u90ae\u7bb1 " + email + " \u5df2\u5b58\u5728"));
        String phone = authInfo.getMobilePhone();
        Assert.isNotBlank((String)phone, (String)"\u624b\u673a\u53f7\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isNull(this.userService.queryByMobilePhone(phone).orElse(null), (String)("\u624b\u673a\u53f7\u7801 " + phone + " \u5df2\u5b58\u5728"));
        Assert.isNotBlank((String)authInfo.getOrgName(), (String)"\u673a\u6784\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isNotBlank((String)authInfo.getNationId(), (String)"\u6240\u5728\u5730\u533a\u4e0d\u80fd\u4e3a\u7a7a");
        if (NationUtils.isChina(authInfo.getNationId())) {
            Assert.isNotBlank((String)authInfo.getProvinceId(), (String)"\u7701\u4e0d\u80fd\u4e3a\u7a7a");
            Assert.isNotBlank((String)authInfo.getCityId(), (String)"\u5e02\u4e0d\u80fd\u4e3a\u7a7a");
            Assert.isNotBlank((String)authInfo.getCountyId(), (String)"\u533a\u4e0d\u80fd\u4e3a\u7a7a");
        }
        Assert.isNotBlank((String)authInfo.getAddress(), (String)"\u8be6\u7ec6\u5730\u5740\u4e0d\u80fd\u4e3a\u7a7a");
    }

    private void validateSessionMobile(HttpSession session, String mobile, String sessionKey) {
        Assert.isNotBlank((String)mobile, (String)"\u624b\u673a\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        Object sessionMobile = session.getAttribute(sessionKey);
        if (!mobile.equals(sessionMobile)) {
            throw new CommonException("\u9a8c\u8bc1\u7801\u5df2\u8fc7\u671f,\u8bf7\u91cd\u65b0\u83b7\u53d6");
        }
    }

    private void validateSessionVerifyCode(HttpSession session, String verifyCode, String sessionKey) {
        Assert.isNotBlank((String)verifyCode, (String)"\u9a8c\u8bc1\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        VerifyCode sessionVerifyCode = (VerifyCode)session.getAttribute(sessionKey);
        Assert.isNotNull((Object)sessionVerifyCode, (String)"\u8bf7\u5148\u83b7\u53d6\u9a8c\u8bc1\u7801");
        if (sessionVerifyCode.isExpried()) {
            session.removeAttribute(sessionKey);
            throw new CommonException("\u9a8c\u8bc1\u7801\u5df2\u8fc7\u671f,\u8bf7\u91cd\u65b0\u83b7\u53d6");
        }
        if (!StringUtils.equals((String)sessionVerifyCode.getCode(), (String)verifyCode)) {
            if (sessionVerifyCode.isTryTimesUseOut()) {
                throw new CommonException("\u64cd\u4f5c\u9891\u7e41,\u8bf7\u7a0d\u5019\u518d\u8bd5");
            }
            throw new CommonException("\u9a8c\u8bc1\u7801\u9519\u8bef");
        }
    }

    @ApiOperation(value="\u4fee\u6539\u7528\u6237\u5934\u50cf", httpMethod="POST")
    @RequestMapping(value={"/service/modifAvatar"})
    @ResponseBody
    public ResponseResult<String> modifAvatar(@RequestParam(required=false) String avatar) {
        Assert.isNotBlank((String)avatar, (String)"\u5934\u50cf\u7684\u94fe\u63a5\u4e0d\u80fd\u4e3a\u7a7a");
        this.userService.modifyAvatar(SpringSecurityUtils.getLoginUserId(), avatar);
        SpringSecurityUtils.getLoginUser().setUserImg(avatar);
        return ResponseResult.success();
    }
}

