/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.auth.web.security.impl;

import com.els.base.auth.exception.InVaildSessionForAnonymousException;
import com.els.base.auth.utils.AnonymousMatcherUtils;
import com.els.base.core.entity.ResponseResult;
import com.els.base.core.utils.ResponseCode;
import com.els.base.utils.http.HttpResponseUtils;
import java.io.IOException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.security.web.DefaultRedirectStrategy;
import org.springframework.security.web.RedirectStrategy;
import org.springframework.security.web.session.InvalidSessionStrategy;
import org.springframework.security.web.util.UrlUtils;
import org.springframework.stereotype.Component;
import org.springframework.util.Assert;

@Component(value="customInvalidSessionStrategy")
public class CustomInvalidSessionStrategy
implements InvalidSessionStrategy {
    private final Log logger = LogFactory.getLog(this.getClass());
    private final String destinationUrl;
    private final RedirectStrategy redirectStrategy = new DefaultRedirectStrategy();
    private boolean createNewSession = true;

    public CustomInvalidSessionStrategy() {
        this("/login.html");
    }

    public CustomInvalidSessionStrategy(String invalidSessionUrl) {
        Assert.isTrue((boolean)UrlUtils.isValidRedirectUrl((String)invalidSessionUrl), (String)"url must start with '/' or with 'http(s)'");
        this.destinationUrl = invalidSessionUrl;
    }

    public void onInvalidSessionDetected(HttpServletRequest request, HttpServletResponse response) throws IOException {
        if (AnonymousMatcherUtils.isAnonymousAccess(request) && !request.isRequestedSessionIdValid()) {
            throw new InVaildSessionForAnonymousException();
        }
        this.logger.debug((Object)("Starting new session (if required) and redirecting to '" + this.destinationUrl + "'"));
        if (this.createNewSession) {
            request.getSession();
        }
        HttpResponseUtils.responseResutlAsJson((HttpServletResponse)response, (Object)ResponseResult.fail((ResponseCode)ResponseCode.Account_No_Login));
    }

    public void setCreateNewSession(boolean createNewSession) {
        this.createNewSession = createNewSession;
    }
}

