/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.auth.web.security.mobile;

import com.els.base.auth.web.security.mobile.MobileAuthenticationToken;
import com.els.base.core.entity.user.User;
import com.els.base.core.service.user.UserService;
import org.springframework.security.authentication.AccountExpiredException;
import org.springframework.security.authentication.AuthenticationProvider;
import org.springframework.security.authentication.DisabledException;
import org.springframework.security.authentication.LockedException;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.security.core.userdetails.UserDetailsService;
import org.springframework.security.core.userdetails.UsernameNotFoundException;

public class MobileAuthenticationProvider
implements AuthenticationProvider {
    private UserService userService;
    private UserDetailsService userDetailsService;

    public Authentication authenticate(Authentication authentication) throws AuthenticationException {
        MobileAuthenticationToken authenticationToken = (MobileAuthenticationToken)authentication;
        User user = (User)this.userService.queryByMobilePhone((String)authenticationToken.getPrincipal()).orElseThrow(() -> new UsernameNotFoundException("\u624b\u673a\u53f7\u7801\u4e0d\u5b58\u5728"));
        UserDetails userDetails = this.userDetailsService.loadUserByUsername(user.getLoginName());
        if (userDetails == null) {
            throw new UsernameNotFoundException("\u7528\u6237\u540d/\u5bc6\u7801\u65e0\u6548");
        }
        if (!userDetails.isEnabled()) {
            throw new DisabledException("\u7528\u6237\u5df2\u88ab\u7981\u7528");
        }
        if (!userDetails.isAccountNonExpired()) {
            throw new AccountExpiredException("\u8d26\u53f7\u5df2\u8fc7\u671f");
        }
        if (!userDetails.isAccountNonLocked()) {
            throw new LockedException("\u8d26\u53f7\u5df2\u88ab\u9501\u5b9a");
        }
        if (!userDetails.isCredentialsNonExpired()) {
            throw new LockedException("\u51ed\u8bc1\u5df2\u8fc7\u671f");
        }
        MobileAuthenticationToken authenticationResult = new MobileAuthenticationToken(userDetails, userDetails.getAuthorities());
        authenticationResult.setDetails(authenticationToken.getDetails());
        return authenticationResult;
    }

    public boolean supports(Class<?> authentication) {
        return MobileAuthenticationToken.class.isAssignableFrom(authentication);
    }

    public UserService getUserService() {
        return this.userService;
    }

    public void setUserService(UserService userService) {
        this.userService = userService;
    }

    public UserDetailsService getUserDetailsService() {
        return this.userDetailsService;
    }

    public void setUserDetailsService(UserDetailsService userDetailsService) {
        this.userDetailsService = userDetailsService;
    }
}

