/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.auth.web.security.mobile;

import com.els.base.auth.web.security.mobile.MobileAuthenticationFilter;
import com.els.base.auth.web.security.mobile.MobileAuthenticationProvider;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Resource;
import javax.servlet.Filter;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.security.authentication.AuthenticationProvider;
import org.springframework.security.authentication.ProviderManager;
import org.springframework.security.config.annotation.SecurityConfigurerAdapter;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.core.userdetails.UserDetailsService;
import org.springframework.security.web.DefaultSecurityFilterChain;
import org.springframework.security.web.authentication.AuthenticationFailureHandler;
import org.springframework.security.web.authentication.AuthenticationSuccessHandler;
import org.springframework.security.web.authentication.UsernamePasswordAuthenticationFilter;
import org.springframework.stereotype.Component;

@Component(value="mobileAuthenticationSecurityConfig")
public class MobileAuthenticationSecurityConfig
extends SecurityConfigurerAdapter<DefaultSecurityFilterChain, HttpSecurity> {
    @Resource(name="mobileCustomUserDetailsService")
    private UserDetailsService userDetailsService;
    @Resource(name="customAuthenticationFailureHandler")
    AuthenticationFailureHandler failureHandler;
    @Resource(name="customAuthenticationSuccessHandler")
    protected AuthenticationSuccessHandler successHandler;

    public void configure(HttpSecurity httpSecurity) throws Exception {
        MobileAuthenticationFilter mobileAuthenticationFilter = new MobileAuthenticationFilter();
        mobileAuthenticationFilter.setAuthenticationManager(this.getAuthenticationManager());
        mobileAuthenticationFilter.setAuthenticationSuccessHandler(this.successHandler);
        mobileAuthenticationFilter.setAuthenticationFailureHandler(this.failureHandler);
        MobileAuthenticationProvider mobileAuthenticationProvider = new MobileAuthenticationProvider();
        mobileAuthenticationProvider.setUserDetailsService(this.userDetailsService);
        httpSecurity.authenticationProvider((AuthenticationProvider)mobileAuthenticationProvider).addFilterBefore((Filter)mobileAuthenticationFilter, UsernamePasswordAuthenticationFilter.class);
    }

    protected AuthenticationManager getAuthenticationManager() {
        MobileAuthenticationProvider authenticationProvider = new MobileAuthenticationProvider();
        authenticationProvider.setUserDetailsService(this.userDetailsService);
        List<AuthenticationProvider> providers = Arrays.asList(authenticationProvider);
        ProviderManager authenticationManager = new ProviderManager(providers);
        return authenticationManager;
    }
}

