-- ----------------------------
-- 按钮配置
-- ----------------------------
-- DROP TABLE "T_BASE_AUTH_BUTTON";
CREATE TABLE "T_BASE_AUTH_BUTTON"
(
    "ID"          VARCHAR2(32 BYTE)    NOT NULL,
    "BTN_NAME"    VARCHAR2(255 BYTE)   NOT NULL,
    "BTN_CODE"    VARCHAR2(255 BYTE)   NOT NULL,
    "OPER_ICON"   VARCHAR2(255 BYTE),
    "MENU_ID"     VARCHAR2(32 BYTE)    NOT NULL,
    "MENU_NAME"   VARCHAR2(255 BYTE),
    "MENU_CODE"   VARCHAR2(255 BYTE),
    "CREATE_TIME" DATE DEFAULT sysdate NOT NULL,
    "UPDATE_TIME" DATE DEFAULT sysdate NOT NULL,
    "PROJECT_ID"  VARCHAR2(32 BYTE)
);

COMMENT ON COLUMN "T_BASE_AUTH_BUTTON"."ID" IS '按钮id';
COMMENT ON COLUMN "T_BASE_AUTH_BUTTON"."BTN_NAME" IS '按钮名称';
COMMENT ON COLUMN "T_BASE_AUTH_BUTTON"."BTN_CODE" IS '按钮编码';
COMMENT ON COLUMN "T_BASE_AUTH_BUTTON"."OPER_ICON" IS '按钮的icon';
COMMENT ON COLUMN "T_BASE_AUTH_BUTTON"."MENU_ID" IS '按钮属于哪个菜单页面';
COMMENT ON COLUMN "T_BASE_AUTH_BUTTON"."MENU_NAME" IS '按钮属于的菜单页面';
COMMENT ON COLUMN "T_BASE_AUTH_BUTTON"."MENU_CODE" IS '按钮属于的菜单code';
COMMENT ON COLUMN "T_BASE_AUTH_BUTTON"."CREATE_TIME" IS '创建时间';
COMMENT ON COLUMN "T_BASE_AUTH_BUTTON"."UPDATE_TIME" IS '更新时间';
COMMENT ON COLUMN "T_BASE_AUTH_BUTTON"."PROJECT_ID" IS '项目id';
COMMENT ON TABLE "T_BASE_AUTH_BUTTON" IS '按钮配置';

ALTER TABLE "T_BASE_AUTH_BUTTON"
    ADD PRIMARY KEY ("ID");


-- ----------------------------
-- 用户组
-- ----------------------------
-- DROP TABLE "T_BASE_AUTH_GROUP";
CREATE TABLE "T_BASE_AUTH_GROUP"
(
    "ID"         NVARCHAR2(32) NOT NULL,
    "PARENT_ID"  NVARCHAR2(32),
    "PROJECT_ID" NVARCHAR2(32),
    "NAME"       NVARCHAR2(255),
    "CODE"       NVARCHAR2(255),
    "IS_ENABLE"  NUMBER(11) DEFAULT 1
);

COMMENT ON COLUMN "T_BASE_AUTH_GROUP"."ID" IS '主键';
COMMENT ON COLUMN "T_BASE_AUTH_GROUP"."PARENT_ID" IS '上级用户组id';
COMMENT ON COLUMN "T_BASE_AUTH_GROUP"."NAME" IS '用户组名称';
COMMENT ON COLUMN "T_BASE_AUTH_GROUP"."CODE" IS '用户组代码，唯一码';
COMMENT ON COLUMN "T_BASE_AUTH_GROUP"."IS_ENABLE" IS '是否可用，1可用，0禁用';
COMMENT ON TABLE "T_BASE_AUTH_GROUP" IS '用户组';

ALTER TABLE "T_BASE_AUTH_GROUP"
    ADD PRIMARY KEY ("ID");

-- ----------------------------
-- 用户组与角色的关系
-- ----------------------------
-- DROP TABLE "T_BASE_AUTH_GROUP_ROLE_REF";
CREATE TABLE "T_BASE_AUTH_GROUP_ROLE_REF"
(
    "ID"            NVARCHAR2(32) NOT NULL,
    "USER_GROUP_ID" NVARCHAR2(32),
    "ROLE_ID"       NVARCHAR2(32)
);

COMMENT ON COLUMN "T_BASE_AUTH_GROUP_ROLE_REF"."ID" IS '主键';
COMMENT ON COLUMN "T_BASE_AUTH_GROUP_ROLE_REF"."USER_GROUP_ID" IS '组织id';
COMMENT ON COLUMN "T_BASE_AUTH_GROUP_ROLE_REF"."ROLE_ID" IS '角色id';
COMMENT ON TABLE "T_BASE_AUTH_GROUP_ROLE_REF" IS '用户组与角色的关系';

ALTER TABLE "T_BASE_AUTH_GROUP_ROLE_REF"
    ADD PRIMARY KEY ("ID");

-- ----------------------------
-- 用户组和用户的关系
-- ----------------------------
-- DROP TABLE "T_BASE_AUTH_GROUP_USER_REF";
CREATE TABLE "T_BASE_AUTH_GROUP_USER_REF"
(
    "ID"            NVARCHAR2(32) NOT NULL,
    "USER_ID"       NVARCHAR2(32),
    "USER_GROUP_ID" NVARCHAR2(32)
);

COMMENT ON COLUMN "T_BASE_AUTH_GROUP_USER_REF"."ID" IS '主键';
COMMENT ON COLUMN "T_BASE_AUTH_GROUP_USER_REF"."USER_ID" IS '用户id';
COMMENT ON COLUMN "T_BASE_AUTH_GROUP_USER_REF"."USER_GROUP_ID" IS '用户组id';
COMMENT ON TABLE "T_BASE_AUTH_GROUP_USER_REF" IS '用户组和用户的关系';

ALTER TABLE "T_BASE_AUTH_GROUP_USER_REF"
    ADD PRIMARY KEY ("ID");


-- ----------------------------
-- 菜单
-- ----------------------------
-- DROP TABLE "T_BASE_AUTH_MENU";
CREATE TABLE "T_BASE_AUTH_MENU"
(
    "ID"          NVARCHAR2(32)              NOT NULL,
    "PARENT_ID"   NVARCHAR2(32)              NOT NULL,
    "MENU_TYPE"   NVARCHAR2(50),
    "MENU_NAME"   NVARCHAR2(100)             NOT NULL,
    "MENU_CODE"   NVARCHAR2(255),
    "MENU_URL"    NVARCHAR2(200),
    "SORT_NO"     NUMBER(11) DEFAULT 0       NOT NULL,
    "CREATE_TIME" DATE       DEFAULT sysdate NOT NULL,
    "UPDATE_TIME" DATE       DEFAULT sysdate NOT NULL,
    "MENU_LOGO"   NVARCHAR2(100),
    "MENU_DESC"   VARCHAR2(255 BYTE)
);

COMMENT ON COLUMN "T_BASE_AUTH_MENU"."ID" IS '菜单Id';
COMMENT ON COLUMN "T_BASE_AUTH_MENU"."PARENT_ID" IS '父类菜单Id';
COMMENT ON COLUMN "T_BASE_AUTH_MENU"."MENU_TYPE" IS '菜单类型：菜单组module，菜单menu';
COMMENT ON COLUMN "T_BASE_AUTH_MENU"."MENU_NAME" IS '菜单名称';
COMMENT ON COLUMN "T_BASE_AUTH_MENU"."MENU_CODE" IS '菜单栏目代码';
COMMENT ON COLUMN "T_BASE_AUTH_MENU"."MENU_URL" IS '菜单请求地址';
COMMENT ON COLUMN "T_BASE_AUTH_MENU"."SORT_NO" IS '菜单排序号';
COMMENT ON COLUMN "T_BASE_AUTH_MENU"."CREATE_TIME" IS '插入时间';
COMMENT ON COLUMN "T_BASE_AUTH_MENU"."UPDATE_TIME" IS '更新日期';
COMMENT ON COLUMN "T_BASE_AUTH_MENU"."MENU_LOGO" IS '菜单logo图标';
COMMENT ON COLUMN "T_BASE_AUTH_MENU"."MENU_DESC" IS '菜单名称描述';
COMMENT ON TABLE "T_BASE_AUTH_MENU" IS '菜单';

ALTER TABLE "T_BASE_AUTH_MENU"
    ADD PRIMARY KEY ("ID");


-- ----------------------------
-- 菜单和页面操作按钮
-- ----------------------------
-- DROP TABLE "T_BASE_AUTH_OPERATOR";
CREATE TABLE "T_BASE_AUTH_OPERATOR"
(
    "ID"          NVARCHAR2(32)        NOT NULL,
    "OPER_NAME"   NVARCHAR2(20)        NOT NULL,
    "OPER_CODE"   NVARCHAR2(255)       NOT NULL,
    "OPER_URL"    NVARCHAR2(50)        NOT NULL,
    "MENU_ID"     NVARCHAR2(32)        NOT NULL,
    "MENU_NAME"   NVARCHAR2(255),
    "MENU_CODE"   NVARCHAR2(255),
    "CREATE_TIME" DATE DEFAULT sysdate NOT NULL,
    "UPDATE_TIME" DATE DEFAULT sysdate NOT NULL,
    "PROJECT_ID"  NVARCHAR2(32)
);

COMMENT ON COLUMN "T_BASE_AUTH_OPERATOR"."ID" IS '页面按钮的操作Id';
COMMENT ON COLUMN "T_BASE_AUTH_OPERATOR"."OPER_NAME" IS '页面按钮的操作名称';
COMMENT ON COLUMN "T_BASE_AUTH_OPERATOR"."OPER_CODE" IS '页面按钮的操作码';
COMMENT ON COLUMN "T_BASE_AUTH_OPERATOR"."OPER_URL" IS '页面按钮的操作地址';
COMMENT ON COLUMN "T_BASE_AUTH_OPERATOR"."MENU_ID" IS '操作属于哪个菜单页面的Id';
COMMENT ON COLUMN "T_BASE_AUTH_OPERATOR"."CREATE_TIME" IS '创建时间';
COMMENT ON COLUMN "T_BASE_AUTH_OPERATOR"."UPDATE_TIME" IS '更新时间';
COMMENT ON COLUMN "T_BASE_AUTH_OPERATOR"."PROJECT_ID" IS '项目id';
COMMENT ON TABLE "T_BASE_AUTH_OPERATOR" IS '菜单和页面操作按钮';

ALTER TABLE "T_BASE_AUTH_OPERATOR"
    ADD PRIMARY KEY ("ID");


-- ----------------------------
-- 用户角色
-- ----------------------------
-- DROP TABLE "T_BASE_AUTH_ROLE";
CREATE TABLE "T_BASE_AUTH_ROLE"
(
    "ID"             NVARCHAR2(32)              NOT NULL,
    "ROLE_NAME"      NVARCHAR2(50)              NOT NULL,
    "ROLE_LEVEL"     NUMBER(11) DEFAULT 200     NOT NULL,
    "ROLE_CODE"      NVARCHAR2(30),
    "CREATE_USER_ID" NVARCHAR2(32),
    "CREATE_TIME"    DATE       DEFAULT sysdate NOT NULL,
    "UPDATE_TIME"    DATE       DEFAULT sysdate NOT NULL,
    "PROJECT_ID"     NVARCHAR2(32),
    "COMPANY_ID"     VARCHAR2(32 BYTE),
    "ROLE_DESC"      VARCHAR2(255 BYTE)
);

COMMENT ON COLUMN "T_BASE_AUTH_ROLE"."ID" IS 'id';
COMMENT ON COLUMN "T_BASE_AUTH_ROLE"."ROLE_NAME" IS '角色名称';
COMMENT ON COLUMN "T_BASE_AUTH_ROLE"."ROLE_LEVEL" IS '角色级别，系统级别100，用户自定义200';
COMMENT ON COLUMN "T_BASE_AUTH_ROLE"."ROLE_CODE" IS '角色编码';
COMMENT ON COLUMN "T_BASE_AUTH_ROLE"."CREATE_USER_ID" IS '角色的创建者Id';
COMMENT ON COLUMN "T_BASE_AUTH_ROLE"."CREATE_TIME" IS '创建时间';
COMMENT ON COLUMN "T_BASE_AUTH_ROLE"."UPDATE_TIME" IS '更新时间';
COMMENT ON COLUMN "T_BASE_AUTH_ROLE"."PROJECT_ID" IS '项目ID';
COMMENT ON COLUMN "T_BASE_AUTH_ROLE"."COMPANY_ID" IS '公司ID';
COMMENT ON COLUMN "T_BASE_AUTH_ROLE"."ROLE_DESC" IS '角色描述';
COMMENT ON TABLE "T_BASE_AUTH_ROLE" IS '用户角色';


ALTER TABLE "T_BASE_AUTH_ROLE"
    ADD PRIMARY KEY ("ID");


-- ----------------------------
-- 角色和权限映射
-- ----------------------------
-- DROP TABLE "T_BASE_AUTH_ROLE_RIGHT";
CREATE TABLE "T_BASE_AUTH_ROLE_RIGHT"
(
    "ID"         NVARCHAR2(32)        NOT NULL,
    "ROLE_ID"    NVARCHAR2(32)        NOT NULL,
    "KEY_ID"     NVARCHAR2(32)        NOT NULL,
    "TYPE"       NVARCHAR2(11)        NOT NULL,
    "CREATETIME" DATE DEFAULT sysdate NOT NULL
);
COMMENT ON COLUMN "T_BASE_AUTH_ROLE_RIGHT"."ID" IS '主键';
COMMENT ON COLUMN "T_BASE_AUTH_ROLE_RIGHT"."ROLE_ID" IS '角色Id';
COMMENT ON COLUMN "T_BASE_AUTH_ROLE_RIGHT"."KEY_ID" IS '关联id';
COMMENT ON COLUMN "T_BASE_AUTH_ROLE_RIGHT"."TYPE" IS '类型:菜单menu,请求request,应用app';
COMMENT ON COLUMN "T_BASE_AUTH_ROLE_RIGHT"."CREATETIME" IS '创建时间';
COMMENT ON TABLE "T_BASE_AUTH_ROLE_RIGHT" IS '角色和权限映射';

ALTER TABLE "T_BASE_AUTH_ROLE_RIGHT"
    ADD PRIMARY KEY ("ID");

-- ----------------------------
-- 用户和角色映射
-- ----------------------------
-- DROP TABLE "T_BASE_AUTH_USER_ROLE";
CREATE TABLE "T_BASE_AUTH_USER_ROLE"
(
    "ID"          NVARCHAR2(32)        NOT NULL,
    "USER_ID"     NVARCHAR2(32)        NOT NULL,
    "ROLE_ID"     NVARCHAR2(32)        NOT NULL,
    "CREATE_TIME" DATE DEFAULT sysdate NOT NULL
);

COMMENT ON COLUMN "T_BASE_AUTH_USER_ROLE"."ID" IS '主键';
COMMENT ON COLUMN "T_BASE_AUTH_USER_ROLE"."USER_ID" IS '用户id';
COMMENT ON COLUMN "T_BASE_AUTH_USER_ROLE"."ROLE_ID" IS '角色id';
COMMENT ON COLUMN "T_BASE_AUTH_USER_ROLE"."CREATE_TIME" IS '创建时间';
COMMENT ON TABLE "T_BASE_AUTH_USER_ROLE" IS '用户和角色映射';

ALTER TABLE "T_BASE_AUTH_USER_ROLE"
    ADD PRIMARY KEY ("ID");



-- ----------------------------
-- 用户组
-- ----------------------------
-- DROP TABLE "T_BASE_AUTH_USER_GROUP";
CREATE TABLE "T_BASE_AUTH_USER_GROUP"
(
    "ID"         NVARCHAR2(32) NOT NULL,
    "PARENT_ID"  NVARCHAR2(32),
    "PROJECT_ID" NVARCHAR2(32),
    "NAME"       NVARCHAR2(255),
    "CODE"       NVARCHAR2(255),
    "IS_ENABLE"  NUMBER(11) DEFAULT 1
);

COMMENT ON COLUMN "T_BASE_AUTH_USER_GROUP"."ID" IS '主键';
COMMENT ON COLUMN "T_BASE_AUTH_USER_GROUP"."PARENT_ID" IS '上级用户组id';
COMMENT ON COLUMN "T_BASE_AUTH_USER_GROUP"."PROJECT_ID" IS '项目ID';
COMMENT ON COLUMN "T_BASE_AUTH_USER_GROUP"."NAME" IS '用户组名称';
COMMENT ON COLUMN "T_BASE_AUTH_USER_GROUP"."CODE" IS '用户组代码，唯一码';
COMMENT ON COLUMN "T_BASE_AUTH_USER_GROUP"."IS_ENABLE" IS '是否可用，1可用，0禁用';
COMMENT ON TABLE "T_BASE_AUTH_USER_GROUP" IS '用户组';

ALTER TABLE "T_BASE_AUTH_USER_GROUP"
    ADD PRIMARY KEY ("ID");














