/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.auth.web.controller;

import com.els.base.auth.entity.Menu;
import com.els.base.auth.entity.Role;
import com.els.base.auth.entity.RoleExample;
import com.els.base.auth.enumeration.RoleEnum;
import com.els.base.auth.service.MenuService;
import com.els.base.auth.service.RoleService;
import com.els.base.auth.utils.SpringSecurityUtils;
import com.els.base.auth.vo.RoleVo;
import com.els.base.core.entity.IExample;
import com.els.base.core.entity.PageView;
import com.els.base.core.entity.ResponseResult;
import com.els.base.core.exception.CommonException;
import com.els.base.core.utils.Assert;
import com.els.base.core.utils.CriteriaUtils;
import com.els.base.core.utils.project.ProjectUtils;
import com.els.base.core.utils.query.QueryParam;
import com.els.base.core.utils.query.QueryParamWapper;
import com.els.base.utils.excel.EasyPoiExcelUtils;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.time.DateFormatUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Api(value="\u6743\u9650\u7ba1\u7406-\u89d2\u8272\u7ba1\u7406")
@Controller
@RequestMapping(value={"role"})
public class RoleController {
    Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private RoleService roleService;
    @Autowired
    private MenuService menuService;

    @ApiOperation(value="\u6dfb\u52a0\u89d2\u8272", httpMethod="POST")
    @RequestMapping(value={"service/addRole"})
    @ResponseBody
    public ResponseResult<String> addRole(@RequestBody Role role) {
        role.setId(null);
        role.setProjectId(ProjectUtils.getProjectId());
        role.setCreateUserId(SpringSecurityUtils.getLoginUserId());
        role.setCompanyId("1");
        this.roleService.addObj(role);
        return ResponseResult.success();
    }

    @ApiOperation(value="\u5220\u9664\u89d2\u8272", httpMethod="POST")
    @RequestMapping(value={"service/deleteRole"})
    @ResponseBody
    public ResponseResult<String> deleteRole(@ApiParam(value="\u89d2\u8272id") @RequestParam(required=true) String roleId) {
        Role role = (Role)this.roleService.queryObjById(roleId);
        if (role == null) {
            throw new CommonException("\u8be5\u6570\u636e\u4e0d\u5b58\u5728", "do_not_exists", new Object[]{"\u89d2\u8272\u6570\u636e"});
        }
        if (Role.ROLE_LEVEL_SYS.equals(role.getRoleLevel()) && !SpringSecurityUtils.isManagerLoginUser()) {
            throw new CommonException("\u8be5\u89d2\u8272\u662f\u7cfb\u7edf\u89d2\u8272\u65e0\u6cd5\u4fee\u6539", "can_not_delete_sys_role");
        }
        this.roleService.deleteObjById(roleId);
        return ResponseResult.success();
    }

    @ApiOperation(value="\u4fee\u6539\u89d2\u8272\u4fe1\u606f", httpMethod="POST")
    @RequestMapping(value={"service/modifyRole"})
    @ResponseBody
    public ResponseResult<String> modifyRole(@RequestBody Role role) {
        Role temp = (Role)this.roleService.queryObjById(role.getId());
        if (Role.ROLE_LEVEL_SYS.equals(temp.getRoleLevel()) && !SpringSecurityUtils.isManagerLoginUser()) {
            throw new CommonException("\u8be5\u89d2\u8272\u662f\u7cfb\u7edf\u89d2\u8272\u65e0\u6cd5\u4fee\u6539", "can_not_delete_sys_role");
        }
        role.setRoleLevel(null);
        role.setProjectId(temp.getProjectId());
        role.setCompanyId(temp.getCompanyId());
        this.roleService.modifyObj(role);
        return ResponseResult.success();
    }

    @ApiOperation(value="\u67e5\u8be2\u6240\u6709\u89d2\u8272\uff0c\u5e76\u6807\u8bb0\u662f\u5426\u5df2\u6388\u6743", httpMethod="GET")
    @RequestMapping(value={"service/queryAllRoleWithAuthTag"})
    @ResponseBody
    public ResponseResult<List<Role>> queryAllRoleWithAuthTag(@ApiParam(value="\u7528\u6237id") String userId) {
        if (StringUtils.isBlank((String)userId)) {
            throw new CommonException("id\u4e3a\u7a7a\uff0c\u4e0d\u80fd\u64cd\u4f5c", "id_is_blank");
        }
        List<String> roleIds = SpringSecurityUtils.getLoginUserRoleIdList();
        if (CollectionUtils.isEmpty(roleIds)) {
            return ResponseResult.success(Collections.emptyList());
        }
        RoleExample roleExample = new RoleExample();
        RoleExample.Criteria criteria = roleExample.createCriteria();
        String smRoleId = this.roleService.queryByRoleCode(RoleEnum.SYSTEM_MANAGER.code()).map(Role::getId).orElse("1");
        if (!roleIds.contains(smRoleId)) {
            criteria.andProjectIdEqualTo(ProjectUtils.getProjectId()).andIdIn((List)roleIds).andRoleLevelNotEqualTo(Role.ROLE_LEVEL_SYS);
        }
        List allRoles = this.roleService.queryAllObjByExample((IExample)roleExample);
        List<Role> rolesOfUser = this.roleService.queryUserOwnRoles(userId);
        if (CollectionUtils.isEmpty(rolesOfUser)) {
            return ResponseResult.success((Object)allRoles);
        }
        ArrayList<String> roleIdsOfUser = new ArrayList<String>();
        for (Role role : rolesOfUser) {
            roleIdsOfUser.add(role.getId());
        }
        for (Role role : allRoles) {
            role.setAuthorized(roleIdsOfUser.contains(role.getId()));
        }
        return ResponseResult.success((Object)allRoles);
    }

    @ApiOperation(value="\u5206\u9875\u67e5\u8be2\u6240\u6709\u7684\u89d2\u8272", httpMethod="POST")
    @RequestMapping(value={"service/queryAllRoleByPage"})
    @ResponseBody
    public ResponseResult<PageView<Role>> queryAllRoleByPage(@ApiParam(value="\u6240\u5728\u9875", defaultValue="1") @RequestParam(defaultValue="1") int pageNo, @ApiParam(value="\u6bcf\u9875\u6570\u91cf", defaultValue="10") @RequestParam(defaultValue="10") int pageSize, @ApiParam(value="\u67e5\u8be2\u6761\u4ef6") @RequestBody(required=false) List<QueryParam> queryParams) {
        List<String> roleIds = SpringSecurityUtils.getLoginUserRoleIdList();
        RoleExample roleExample = new RoleExample();
        roleExample.setPageView((PageView<Role>)new PageView(pageNo, pageSize));
        RoleExample.Criteria criteria = roleExample.createCriteria();
        if (!SpringSecurityUtils.isManagerLoginUser()) {
            criteria.andProjectIdEqualTo(ProjectUtils.getProjectId()).andIdIn((List)roleIds);
            RoleExample.Criteria or = roleExample.or();
            or.andProjectIdEqualTo(ProjectUtils.getProjectId()).andCompanyIdEqualTo("1");
        }
        if (CollectionUtils.isNotEmpty(queryParams)) {
            CriteriaUtils.addCriterion((Object)criteria, queryParams);
        }
        roleExample.setOrderByClause("CREATE_TIME DESC");
        PageView pageData = this.roleService.queryObjByPage((IExample)roleExample);
        return ResponseResult.success((Object)pageData);
    }

    @ApiOperation(value="\u5206\u9875\u67e5\u8be2\u6240\u6709\u7684\u89d2\u8272--\u65b0\u578b\u6761\u4ef6", httpMethod="POST")
    @RequestMapping(value={"service/new/queryAllRoleByPage"})
    @ResponseBody
    public ResponseResult<PageView<Role>> queryAllRoleByPageForQueryParamWapper(@ApiParam(value="\u6240\u5728\u9875", defaultValue="0") @RequestParam(defaultValue="0") int pageNo, @ApiParam(value="\u6bcf\u9875\u6570\u91cf", defaultValue="10") @RequestParam(defaultValue="10") int pageSize, @ApiParam(value="\u67e5\u8be2\u6761\u4ef6,\u5c5e\u6027\u540d\u8bf7\u53c2\u8003 Role") @RequestBody(required=false) QueryParamWapper wapper) {
        List<String> roleIds = SpringSecurityUtils.getLoginUserRoleIdList();
        RoleExample roleExample = new RoleExample();
        roleExample.setPageView((PageView<Role>)new PageView(pageNo, pageSize));
        RoleExample.Criteria criteria = roleExample.createCriteria();
        if (!SpringSecurityUtils.isManagerLoginUser()) {
            criteria.andProjectIdEqualTo(ProjectUtils.getProjectId()).andIdIn((List)roleIds);
            RoleExample.Criteria or = roleExample.or();
            or.andProjectIdEqualTo(ProjectUtils.getProjectId()).andCompanyIdEqualTo("1");
        }
        if (wapper != null) {
            CriteriaUtils.addExample((IExample)roleExample, (QueryParamWapper)wapper);
        }
        roleExample.setOrderByClause("CREATE_TIME DESC");
        PageView pageData = this.roleService.queryObjByPage((IExample)roleExample);
        return ResponseResult.success((Object)pageData);
    }

    @ApiOperation(httpMethod="GET", value="\u5bfc\u51fa")
    @RequestMapping(value={"service/export"}, method={RequestMethod.GET})
    public void exportExcel(@RequestParam(required=false) String roleIds, HttpServletResponse response) {
        long start = System.currentTimeMillis();
        RoleExample roleExample = new RoleExample();
        RoleExample.Criteria criteria = roleExample.createCriteria();
        criteria.andProjectIdEqualTo(ProjectUtils.getProjectId());
        if (StringUtils.isNotBlank((String)roleIds)) {
            if (roleIds.contains(",")) {
                Object[] split = StringUtils.split((String)roleIds, (String)",");
                if (ArrayUtils.isNotEmpty((Object[])split)) {
                    List<Object> list = Arrays.asList(split);
                    criteria.andIdIn(list);
                }
            } else {
                criteria.andIdEqualTo(roleIds);
            }
        }
        roleExample.setOrderByClause("CREATE_TIME DESC");
        List roles = this.roleService.queryAllObjByExample((IExample)roleExample);
        Assert.isNotEmpty((Collection)roles, (String)"\u6ca1\u6709\u627e\u5230\u9700\u8981\u5bfc\u51fa\u7684\u6570\u636e\uff0c\u8bf7\u68c0\u67e5");
        ArrayList<RoleVo> listvo = new ArrayList<RoleVo>();
        for (Role role : roles) {
            RoleVo roleVo = new RoleVo();
            BeanUtils.copyProperties((Object)role, (Object)roleVo);
            String id = role.getId();
            List<Menu> list = this.menuService.queryAuthedMenuForRoleIds(Collections.singletonList(id), "menu");
            if (CollectionUtils.isNotEmpty(list)) {
                List collect = list.stream().map(Menu::getMenuName).collect(Collectors.toList());
                String join = StringUtils.join(collect, (String)",");
                roleVo.setApp(join);
            }
            listvo.add(roleVo);
        }
        this.logger.debug("\u5bfc\u51faexcel\u6240\u82b1\u65f6\u95f4\uff1a" + (System.currentTimeMillis() - start));
        try {
            String format = DateFormatUtils.format((Date)new Date(), (String)"yyyyMMddHHmmss");
            EasyPoiExcelUtils.exportExcel(listvo, (String)"\u89d2\u8272\u7ba1\u7406", (String)"\u89d2\u8272\u5217\u8868", RoleVo.class, (String)("\u89d2\u8272\u7ba1\u7406" + format), (HttpServletResponse)response);
        }
        catch (IOException e) {
            this.logger.error("\u5bfc\u51fa\u5931\u8d25{}", (Object)e.getMessage());
            throw new CommonException("\u5bfc\u51fa\u5931\u8d25,\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u68c0\u67e5\uff01");
        }
    }
}

