/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.auth.web.security.mobile;

import com.els.base.auth.entity.AuthUser;
import com.els.base.auth.entity.Role;
import com.els.base.auth.entity.UserGroup;
import com.els.base.auth.entity.UserRole;
import com.els.base.auth.service.RoleService;
import com.els.base.auth.service.UserGroupService;
import com.els.base.auth.service.UserRoleService;
import com.els.base.auth.utils.AuthConstant;
import com.els.base.core.entity.IExample;
import com.els.base.core.entity.user.User;
import com.els.base.core.entity.user.UserExample;
import com.els.base.core.service.user.UserService;
import com.els.base.core.utils.Constant;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.authority.SimpleGrantedAuthority;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.security.core.userdetails.UserDetailsService;
import org.springframework.security.core.userdetails.UsernameNotFoundException;
import org.springframework.stereotype.Service;

@Service(value="mobileCustomUserDetailsService")
public class MobileCustomUserDetailsServiceImpl
implements UserDetailsService {
    @Resource
    private UserService userService;
    @Autowired
    private UserRoleService userRoleService;
    @Resource
    private UserGroupService userGroupService;
    private RoleService roleService;

    public UserDetails loadUserByUsername(String loginNameInput) throws UsernameNotFoundException {
        int i;
        UserExample userExample = new UserExample();
        userExample.createCriteria().andIsEnableEqualTo(Constant.YES_INT).andMobilePhoneEqualTo(loginNameInput);
        List list = this.userService.queryAllObjByExample((IExample)userExample);
        if (list == null || list.size() == 0) {
            throw new UsernameNotFoundException("The user name " + loginNameInput + " can not be found!");
        }
        User user = (User)list.get(0);
        if (user == null) {
            throw new UsernameNotFoundException("The user name " + loginNameInput + " can not be found!");
        }
        ArrayList<GrantedAuthority> authorities = new ArrayList<GrantedAuthority>();
        HashSet<String> roleIdList = new HashSet<String>();
        UserGroup userGroup = this.userGroupService.queryUserGroupsByUserId(user.getId());
        if (userGroup != null) {
            List<Role> roleList = this.roleService.queryAllRoleByUserGroup(userGroup.getId());
            for (i = 0; CollectionUtils.isNotEmpty(roleList) && i < roleList.size(); ++i) {
                roleIdList.add(roleList.get(i).getId());
            }
        }
        List<UserRole> userRoleList = this.userRoleService.queryUserRoleList(user.getId());
        for (i = 0; CollectionUtils.isNotEmpty(userRoleList) && i < userRoleList.size(); ++i) {
            roleIdList.add(userRoleList.get(i).getRoleId());
        }
        for (String roleId : roleIdList) {
            SimpleGrantedAuthority authority = new SimpleGrantedAuthority(roleId.toString());
            authorities.add((GrantedAuthority)authority);
        }
        authorities.add((GrantedAuthority)new SimpleGrantedAuthority(AuthConstant.DEFAULT_ROLE.getId()));
        AuthUser authUser = AuthUser.convertFormBaseUser(user);
        authUser.setAuthorities(authorities);
        return authUser;
    }
}

