/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.auth.web.security.mobile;

import com.els.base.auth.exception.VerifyCodeException;
import com.els.base.auth.web.security.mobile.MobileAuthenticationFilter;
import com.els.base.core.vo.VerifyCode;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.lang.StringUtils;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.AuthenticationException;

public class VerifyCodeFilter
extends MobileAuthenticationFilter {
    @Override
    public Authentication attemptAuthentication(HttpServletRequest request, HttpServletResponse response) throws AuthenticationException {
        HttpSession session = request.getSession();
        String loginMobile = (String)session.getAttribute("login.phone");
        VerifyCode verifyCode = (VerifyCode)session.getAttribute("login.sms.verify.code");
        if (verifyCode == null) {
            throw new VerifyCodeException("\u8bf7\u5148\u83b7\u53d6\u9a8c\u8bc1\u7801");
        }
        String mobile = request.getParameter("mobile");
        String code = request.getParameter("smsCode");
        if (StringUtils.isBlank((String)mobile)) {
            throw new VerifyCodeException("\u8bf7\u8f93\u5165\u624b\u673a\u53f7");
        }
        if (StringUtils.isBlank((String)code)) {
            throw new VerifyCodeException("\u8bf7\u8f93\u5165\u9a8c\u8bc1\u7801");
        }
        if (verifyCode.isExpried() || !mobile.equals(loginMobile)) {
            session.removeAttribute("login.sms.verify.code");
            throw new VerifyCodeException("\u9a8c\u8bc1\u7801\u5df2\u5931\u6548,\u8bf7\u91cd\u65b0\u83b7\u53d6");
        }
        if (!StringUtils.equals((String)verifyCode.getCode(), (String)code)) {
            if (verifyCode.isTryTimesUseOut()) {
                throw new VerifyCodeException("\u64cd\u4f5c\u9891\u7e41,\u8bf7\u7a0d\u5019\u518d\u8bd5");
            }
            throw new VerifyCodeException("\u9a8c\u8bc1\u7801\u9519\u8bef");
        }
        return super.attemptAuthentication(request, response);
    }
}

