/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.auth.web.controller;

import com.els.base.auth.entity.Role;
import com.els.base.auth.entity.RoleExample;
import com.els.base.auth.service.RoleService;
import com.els.base.auth.utils.SpringSecurityUtils;
import com.els.base.core.entity.IExample;
import com.els.base.core.entity.PageView;
import com.els.base.core.entity.ResponseResult;
import com.els.base.core.exception.CommonException;
import com.els.base.core.utils.CriteriaUtils;
import com.els.base.core.utils.project.ProjectUtils;
import com.els.base.core.utils.query.QueryParam;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Api(value="\u6743\u9650\u7ba1\u7406-\u89d2\u8272\u7ba1\u7406")
@Controller
@RequestMapping(value={"role"})
public class RoleController {
    @Autowired
    private RoleService roleService;

    @ApiOperation(value="\u6dfb\u52a0\u89d2\u8272", httpMethod="POST")
    @RequestMapping(value={"service/addRole"})
    @ResponseBody
    public ResponseResult<String> addRole(@RequestBody Role role) {
        role.setId(null);
        role.setProjectId(ProjectUtils.getProjectId());
        role.setCreateUserId(SpringSecurityUtils.getLoginUserId());
        this.roleService.addObj(role);
        return ResponseResult.success();
    }

    @ApiOperation(value="\u5220\u9664\u89d2\u8272", httpMethod="POST")
    @RequestMapping(value={"service/deleteRole"})
    @ResponseBody
    public ResponseResult<String> deleteRole(@ApiParam(value="\u89d2\u8272id") @RequestParam(required=true) String roleId) {
        Role role = (Role)this.roleService.queryObjById(roleId);
        if (role == null) {
            throw new CommonException("\u8be5\u6570\u636e\u4e0d\u5b58\u5728", "do_not_exists", new Object[]{"\u89d2\u8272\u6570\u636e"});
        }
        if (Role.ROLE_LEVEL_SYS.equals(role.getRoleLevel()) && !SpringSecurityUtils.isManagerLoginUser()) {
            throw new CommonException("\u8be5\u89d2\u8272\u662f\u7cfb\u7edf\u89d2\u8272\u65e0\u6cd5\u4fee\u6539", "can_not_delete_sys_role");
        }
        this.roleService.deleteObjById(roleId);
        return ResponseResult.success();
    }

    @ApiOperation(value="\u4fee\u6539\u89d2\u8272\u4fe1\u606f", httpMethod="POST")
    @RequestMapping(value={"service/modifyRole"})
    @ResponseBody
    public ResponseResult<String> modifyRole(@RequestBody Role role) {
        Role temp = (Role)this.roleService.queryObjById(role.getId());
        if (Role.ROLE_LEVEL_SYS.equals(temp.getRoleLevel()) && !SpringSecurityUtils.isManagerLoginUser()) {
            throw new CommonException("\u8be5\u89d2\u8272\u662f\u7cfb\u7edf\u89d2\u8272\u65e0\u6cd5\u4fee\u6539", "can_not_delete_sys_role");
        }
        role.setRoleLevel(null);
        role.setProjectId(temp.getProjectId());
        role.setCompanyId(temp.getCompanyId());
        this.roleService.modifyObj(role);
        return ResponseResult.success();
    }

    @ApiOperation(value="\u67e5\u8be2\u6240\u6709\u89d2\u8272\uff0c\u5e76\u6807\u8bb0\u662f\u5426\u5df2\u6388\u6743", httpMethod="GET")
    @RequestMapping(value={"service/queryAllRoleWithAuthTag"})
    @ResponseBody
    public ResponseResult<List<Role>> queryAllRoleWithAuthTag(@ApiParam(value="\u7528\u6237id") String userId) {
        if (StringUtils.isBlank((String)userId)) {
            throw new CommonException("id\u4e3a\u7a7a\uff0c\u4e0d\u80fd\u64cd\u4f5c", "id_is_blank");
        }
        List allRoles = this.roleService.queryAllObjByExample(null);
        List<Role> rolesOfUser = this.roleService.queryUserOwnRoles(userId);
        if (CollectionUtils.isEmpty(rolesOfUser)) {
            return ResponseResult.success((Object)allRoles);
        }
        ArrayList<String> roleIdsOfUser = new ArrayList<String>();
        for (Role role : rolesOfUser) {
            roleIdsOfUser.add(role.getId());
        }
        for (Role role : allRoles) {
            role.setAuthorized(roleIdsOfUser.contains(role.getId()));
        }
        return ResponseResult.success((Object)allRoles);
    }

    @ApiOperation(value="\u5206\u9875\u67e5\u8be2\u6240\u6709\u7684\u89d2\u8272", httpMethod="POST")
    @RequestMapping(value={"service/queryAllRoleByPage"})
    @ResponseBody
    public ResponseResult<PageView<Role>> queryAllRoleByPage(@ApiParam(value="\u6240\u5728\u9875", defaultValue="1") @RequestParam(defaultValue="1") int pageNo, @ApiParam(value="\u6bcf\u9875\u6570\u91cf", defaultValue="10") @RequestParam(defaultValue="10") int pageSize, @ApiParam(value="\u67e5\u8be2\u6761\u4ef6") @RequestBody(required=false) List<QueryParam> queryParams) {
        RoleExample roleExample = new RoleExample();
        roleExample.setPageView((PageView<Role>)new PageView(pageNo, pageSize));
        RoleExample.Criteria criteria = roleExample.createCriteria();
        criteria.andProjectIdEqualTo(ProjectUtils.getProjectId());
        RoleExample.Criteria or = roleExample.or();
        or.andProjectIdIsNull();
        if (CollectionUtils.isNotEmpty(queryParams)) {
            CriteriaUtils.addCriterion((Object)criteria, queryParams);
        }
        roleExample.setOrderByClause("CREATE_TIME DESC");
        PageView pageData = this.roleService.queryObjByPage((IExample)roleExample);
        return ResponseResult.success((Object)pageData);
    }
}

