/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.auth.web.security.impl;

import com.auth0.jwt.JWT;
import com.auth0.jwt.exceptions.JWTDecodeException;
import com.auth0.jwt.interfaces.DecodedJWT;
import com.els.base.auth.exception.InvalidTokenException;
import java.io.IOException;
import java.util.Date;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.web.authentication.AbstractAuthenticationProcessingFilter;

public class CustomSsoAuthenticationFilter
extends AbstractAuthenticationProcessingFilter {
    private static final Logger logger = LoggerFactory.getLogger(CustomSsoAuthenticationFilter.class);

    public CustomSsoAuthenticationFilter() {
        super("/sso");
    }

    public Authentication attemptAuthentication(HttpServletRequest request, HttpServletResponse response) throws AuthenticationException, IOException, ServletException {
        String token = request.getParameter("token");
        if (StringUtils.isBlank((String)token)) {
            throw new InvalidTokenException("token\u4e0d\u80fd\u4e3a\u7a7a");
        }
        DecodedJWT jwt = null;
        try {
            jwt = JWT.decode((String)token);
        }
        catch (JWTDecodeException e) {
            logger.error("token\u65e0\u6548", (Throwable)e);
            throw new InvalidTokenException("\u65e0\u6548token");
        }
        String subject = jwt.getSubject();
        Date expiresAt = jwt.getExpiresAt();
        if (expiresAt != null && expiresAt.getTime() < System.currentTimeMillis()) {
            throw new InvalidTokenException("token\u5df2\u8fc7\u671f,\u8bf7\u91cd\u65b0\u83b7\u53d6");
        }
        UsernamePasswordAuthenticationToken authRequest = new UsernamePasswordAuthenticationToken((Object)subject, (Object)token);
        return this.getAuthenticationManager().authenticate((Authentication)authRequest);
    }
}

