/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.auth.service.impl;

import com.els.base.auth.dao.UserRightMapper;
import com.els.base.auth.entity.UserRight;
import com.els.base.auth.entity.UserRightExample;
import com.els.base.auth.service.UserRightService;
import com.els.base.core.entity.PageView;
import com.els.base.core.utils.Assert;
import com.els.base.utils.uuid.UUIDGenerator;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="defaultUserRightService")
public class UserRightServiceImpl
implements UserRightService {
    @Resource
    protected UserRightMapper userRightMapper;

    @CacheEvict(value={"userRight"}, allEntries=true)
    public void addObj(UserRight t) {
        this.userRightMapper.insertSelective(t);
    }

    @Transactional
    @CacheEvict(value={"userRight"}, allEntries=true)
    public void addAll(List<UserRight> list) {
        if (CollectionUtils.isEmpty(list)) {
            return;
        }
        list.stream().forEach(item -> {
            if (StringUtils.isBlank((String)item.getId())) {
                item.setId(UUIDGenerator.generateUUID());
            }
        });
        this.userRightMapper.insertBatch(list);
    }

    @CacheEvict(value={"userRight"}, allEntries=true)
    public void deleteObjById(String id) {
        this.userRightMapper.deleteByPrimaryKey(id);
    }

    @CacheEvict(value={"userRight"}, allEntries=true)
    public void deleteByExample(UserRightExample example) {
        Assert.isNotNull((Object)example, (String)"\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isNotEmpty(example.getOredCriteria(), (String)"\u6279\u91cf\u5220\u9664\u4e0d\u80fd\u5168\u8868\u5220\u9664");
        this.userRightMapper.deleteByExample(example);
    }

    @CacheEvict(value={"userRight"}, allEntries=true)
    public void modifyObj(UserRight t) {
        Assert.isNotBlank((String)t.getId(), (String)"id \u4e3a\u7a7a\uff0c\u65e0\u6cd5\u4fee\u6539");
        this.userRightMapper.updateByPrimaryKeySelective(t);
    }

    @Cacheable(value={"userRight"}, keyGenerator="redisKeyGenerator")
    public UserRight queryObjById(String id) {
        return this.userRightMapper.selectByPrimaryKey(id);
    }

    @Cacheable(value={"userRight"}, keyGenerator="redisKeyGenerator")
    public List<UserRight> queryAllObjByExample(UserRightExample example) {
        return this.userRightMapper.selectByExample(example);
    }

    @Cacheable(value={"userRight"}, keyGenerator="redisKeyGenerator")
    public PageView<UserRight> queryObjByPage(UserRightExample example) {
        PageView<UserRight> pageView = example.getPageView();
        pageView.setQueryResult(this.userRightMapper.selectByExampleByPage(example));
        return pageView;
    }
}

