/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.auth.web.security.impl;

import com.els.base.auth.entity.Role;
import com.els.base.auth.utils.AuthConstant;
import java.util.Collection;
import org.springframework.security.access.AccessDecisionManager;
import org.springframework.security.access.AccessDeniedException;
import org.springframework.security.access.ConfigAttribute;
import org.springframework.security.authentication.InsufficientAuthenticationException;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.stereotype.Service;

@Service(value="customAccessDecisionManager")
public class CustomAccessDecisionManagerImpl
implements AccessDecisionManager {
    public void decide(Authentication authentication, Object o, Collection<ConfigAttribute> configAttributes) throws AccessDeniedException, InsufficientAuthenticationException {
        UserDetails details;
        if (null == configAttributes) {
            return;
        }
        boolean isAnonymousAccess = configAttributes.stream().anyMatch(role -> role.equals(AuthConstant.ANONYMOUS_ROLE));
        if (isAnonymousAccess) {
            return;
        }
        Object obj = authentication.getPrincipal();
        if (obj instanceof UserDetails && "admin".equals((details = (UserDetails)obj).getUsername())) {
            return;
        }
        boolean isRightAccess = configAttributes.stream().anyMatch(ca -> {
            String needRole = ((Role)ca).getAttribute();
            for (GrantedAuthority gra : authentication.getAuthorities()) {
                if (!needRole.trim().equals(gra.getAuthority().trim())) continue;
                return true;
            }
            return false;
        });
        if (isRightAccess) {
            return;
        }
        throw new AccessDeniedException("Access Denied");
    }

    public boolean supports(ConfigAttribute configAttribute) {
        return true;
    }

    public boolean supports(Class<?> aClass) {
        return true;
    }
}

