/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.auth.web.security.impl;

import com.els.base.auth.exception.CaptchaErrorException;
import com.els.base.auth.exception.CaptchaNotFoundException;
import com.els.base.auth.exception.InvalidTokenException;
import com.els.base.core.entity.ResponseResult;
import com.els.base.core.utils.ResponseCode;
import com.els.base.utils.http.HttpResponseUtils;
import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.security.authentication.AccountExpiredException;
import org.springframework.security.authentication.AccountStatusException;
import org.springframework.security.authentication.BadCredentialsException;
import org.springframework.security.authentication.CredentialsExpiredException;
import org.springframework.security.authentication.DisabledException;
import org.springframework.security.authentication.LockedException;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.core.userdetails.UsernameNotFoundException;
import org.springframework.security.web.authentication.ExceptionMappingAuthenticationFailureHandler;
import org.springframework.security.web.authentication.session.SessionAuthenticationException;
import org.springframework.stereotype.Component;

@Component(value="customAuthenticationFailureHandler")
public class CustomAuthenticationFailureHandler
extends ExceptionMappingAuthenticationFailureHandler {
    public void onAuthenticationFailure(HttpServletRequest request, HttpServletResponse response, AuthenticationException exception) throws IOException, ServletException {
        ResponseResult<String> result = this.getErrMsg(exception);
        HttpResponseUtils.responseResutlAsJson((HttpServletResponse)response, result);
    }

    private ResponseResult<String> getErrMsg(AuthenticationException exception) {
        if (exception instanceof AccountExpiredException) {
            return ResponseResult.fail((ResponseCode)ResponseCode.Account_Expired);
        }
        if (exception instanceof DisabledException) {
            return ResponseResult.fail((ResponseCode)ResponseCode.Account_Disabled);
        }
        if (exception instanceof LockedException) {
            return ResponseResult.fail((ResponseCode)ResponseCode.Account_Locked);
        }
        if (exception instanceof CredentialsExpiredException) {
            return ResponseResult.fail((ResponseCode)ResponseCode.Accouont_Password_Expired);
        }
        if (exception instanceof AccountStatusException) {
            return ResponseResult.fail((ResponseCode)ResponseCode.Account_Sessioin_Expired);
        }
        if (exception instanceof BadCredentialsException) {
            return ResponseResult.fail((ResponseCode)ResponseCode.Account_Password_Worng);
        }
        if (exception instanceof UsernameNotFoundException) {
            return ResponseResult.fail((ResponseCode)ResponseCode.Account_Username_Not_Found);
        }
        if (exception instanceof SessionAuthenticationException) {
            return ResponseResult.fail((ResponseCode)ResponseCode.Account_Sessioin_Expired);
        }
        if (exception instanceof CaptchaNotFoundException) {
            return ResponseResult.fail((ResponseCode)ResponseCode.Account_Captcha_Not_Found);
        }
        if (exception instanceof CaptchaErrorException) {
            return ResponseResult.fail((ResponseCode)ResponseCode.Account_Captcha_Worng);
        }
        if (exception instanceof InvalidTokenException) {
            ResponseResult result = new ResponseResult();
            result.setCode("403");
            result.setMsg(exception.getMessage());
            return result;
        }
        ResponseResult result = new ResponseResult();
        result.setCode("403");
        result.setMsg("\u767b\u5f55\u5931\u8d25");
        return result;
    }
}

