/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.auth.web.security.impl;

import com.els.base.auth.entity.Role;
import com.els.base.auth.entity.RoleExample;
import com.els.base.auth.service.RoleRightService;
import com.els.base.auth.service.RoleService;
import com.els.base.auth.utils.AnonymousMatcherUtils;
import com.els.base.auth.utils.AuthConstant;
import com.els.base.core.entity.IExample;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.security.access.ConfigAttribute;
import org.springframework.security.web.FilterInvocation;
import org.springframework.security.web.access.intercept.FilterInvocationSecurityMetadataSource;
import org.springframework.stereotype.Component;

@Component(value="customFilterInvocationSecurityMetadataSource")
public class CustomFilterInvocationSecurityMetadataSource
implements FilterInvocationSecurityMetadataSource {
    private static Pattern pattern = Pattern.compile("(.+?)\\?.+");
    @Resource
    private RoleService roleService;
    @Resource
    private RoleRightService roleRightService;

    public Collection<ConfigAttribute> getAttributes(Object object) throws IllegalArgumentException {
        List<Role> roleList;
        HttpServletRequest request = ((FilterInvocation)object).getRequest();
        String url = ((FilterInvocation)object).getRequestUrl().trim();
        if (StringUtils.isBlank((String)url)) {
            return null;
        }
        if (url.contains("?")) {
            Matcher matcher = pattern.matcher(url);
            url = matcher.find() ? matcher.group(1) : url;
        }
        ArrayList<ConfigAttribute> tmpList = new ArrayList<ConfigAttribute>();
        if (AnonymousMatcherUtils.isAnonymousAccess(request)) {
            tmpList.add(AuthConstant.ANONYMOUS_ROLE);
        }
        if (CollectionUtils.isNotEmpty(roleList = this.roleRightService.getRoleByOperatorUrl(url))) {
            CollectionUtils.addAll(tmpList, roleList.iterator());
        } else {
            tmpList.add(AuthConstant.DEFAULT_ROLE);
        }
        return tmpList;
    }

    public Collection<ConfigAttribute> getAllConfigAttributes() {
        RoleExample roleExample = new RoleExample();
        List roleList = this.roleService.queryAllObjByExample((IExample)roleExample);
        ArrayList<ConfigAttribute> tmpList = new ArrayList<ConfigAttribute>();
        CollectionUtils.addAll(tmpList, roleList.iterator());
        return tmpList;
    }

    public boolean supports(Class<?> clazz) {
        return false;
    }
}

