/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.auth.web.controller;

import com.els.base.auth.entity.Role;
import com.els.base.auth.entity.RoleExample;
import com.els.base.auth.entity.UserRole;
import com.els.base.auth.entity.UserRoleExample;
import com.els.base.auth.service.RoleService;
import com.els.base.auth.service.UserRoleService;
import com.els.base.auth.utils.AuthConstant;
import com.els.base.auth.utils.SpringSecurityUtils;
import com.els.base.core.entity.IExample;
import com.els.base.core.entity.ResponseResult;
import com.els.base.core.exception.CommonException;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Api(value="\u6743\u9650\u7ba1\u7406-\u7528\u6237\u89d2\u8272\u5173\u8054\u7ba1\u7406")
@Controller
@RequestMapping(value={"userRole"})
public class UserRoleController {
    @Autowired
    private UserRoleService rightService;
    @Resource
    protected RoleService roleService;

    @ApiOperation(value="\u7ed9\u7528\u6237\u589e\u52a0\u89d2\u8272", httpMethod="POST")
    @RequestMapping(value={"service/addUserRoleRight"})
    @ResponseBody
    public ResponseResult<String> addUserRoleRight(String roleId, String userId) {
        UserRoleExample example = new UserRoleExample();
        example.createCriteria().andUserIdEqualTo(userId).andRoleIdEqualTo(roleId);
        if (CollectionUtils.isNotEmpty((Collection)this.rightService.queryAllObjByExample((IExample)example))) {
            return ResponseResult.success();
        }
        UserRole userRole = new UserRole();
        userRole.setRoleId(roleId);
        userRole.setUserId(userId);
        this.rightService.addObj(userRole);
        return ResponseResult.success();
    }

    @ApiOperation(value="\u7ed9\u7528\u6237\u5220\u9664\u89d2\u8272", httpMethod="POST")
    @RequestMapping(value={"service/deleteUserRoleRight"})
    @ResponseBody
    public ResponseResult<String> deleteUserRight(String rightId) {
        this.rightService.deleteObjById(rightId);
        return ResponseResult.success();
    }

    @ApiOperation(value="\u4fee\u6539\u7528\u6237\u7684\u89d2\u8272", httpMethod="POST")
    @RequestMapping(value={"/modifyUserRoleRight"})
    @ResponseBody
    public ResponseResult<String> modifyUserRight(String rightId, String roleId, String userId) {
        UserRole userRole = new UserRole();
        userRole.setId(rightId);
        userRole.setRoleId(roleId);
        userRole.setUserId(userId);
        this.rightService.modifyObj(userRole);
        return ResponseResult.success();
    }

    @ApiOperation(value="\u7ed9\u7528\u6237\u6dfb\u52a0\u591a\u4e2a\u89d2\u8272", httpMethod="POST")
    @RequestMapping(value={"service/addUserRoleList"})
    @ResponseBody
    public ResponseResult<String> addUserRoleList(String roleIds, String userId) {
        List<String> sysRoleIds;
        if (StringUtils.isBlank((String)roleIds)) {
            throw new CommonException("\u89d2\u8272\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a", "base_canot_be_null", new Object[]{"\u89d2\u8272\u6570\u636e"});
        }
        ArrayList<String> allRole = new ArrayList<String>();
        allRole.addAll(Arrays.asList(roleIds.split(",")));
        if (!this.isMangerUser() && CollectionUtils.isNotEmpty(sysRoleIds = this.querySysRoleOfUser(userId))) {
            allRole.addAll(sysRoleIds);
        }
        String[] roleIdArray = (String[])allRole.stream().distinct().toArray(String[]::new);
        this.rightService.resetUserRole(userId, roleIdArray);
        return ResponseResult.success();
    }

    private boolean isMangerUser() {
        List<Role> roleList = SpringSecurityUtils.getLoginUserRoleList();
        if (CollectionUtils.isEmpty(roleList)) {
            return false;
        }
        for (Role role : roleList) {
            if (!AuthConstant.SYS_MANAGER_ROLE.getRoleCode().equals(role.getRoleCode())) continue;
            return true;
        }
        return false;
    }

    private List<String> querySysRoleOfUser(String userId) {
        List<String> roleIdList = this.rightService.queryUserOwnRoleIds(userId);
        if (CollectionUtils.isEmpty(roleIdList)) {
            return null;
        }
        RoleExample roleExample = new RoleExample();
        roleExample.createCriteria().andIdIn((List)roleIdList).andRoleLevelEqualTo(Role.ROLE_LEVEL_SYS);
        List roleList = this.roleService.queryAllObjByExample((IExample)roleExample);
        if (CollectionUtils.isEmpty((Collection)roleList)) {
            return null;
        }
        return roleList.stream().map(Role::getId).collect(Collectors.toList());
    }
}

