/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.auth.service.impl;

import com.els.base.auth.dao.RoleMapper;
import com.els.base.auth.dao.UserGroupRoleRefMapper;
import com.els.base.auth.entity.Operator;
import com.els.base.auth.entity.Role;
import com.els.base.auth.entity.RoleExample;
import com.els.base.auth.entity.RoleRight;
import com.els.base.auth.entity.RoleRightExample;
import com.els.base.auth.entity.UserGroup;
import com.els.base.auth.entity.UserGroupRoleRef;
import com.els.base.auth.entity.UserGroupRoleRefExample;
import com.els.base.auth.entity.UserRole;
import com.els.base.auth.entity.UserRoleExample;
import com.els.base.auth.service.OperatorService;
import com.els.base.auth.service.RoleRightService;
import com.els.base.auth.service.RoleService;
import com.els.base.auth.service.UserGroupService;
import com.els.base.auth.service.UserRoleService;
import com.els.base.core.entity.IExample;
import com.els.base.core.entity.PageView;
import com.els.base.core.exception.CommonException;
import com.els.base.core.utils.Assert;
import com.els.base.utils.SpringContextHolder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="roleService")
public class RoleServiceImpl
implements RoleService {
    @Autowired
    private RoleMapper roleMapper;
    @Resource
    private UserGroupRoleRefMapper userGroupRoleRefMapper;
    @Resource
    private RoleRightService roleRightService;
    @Resource
    private OperatorService operatorService;
    @Resource
    private UserRoleService userRoleService;
    @Resource
    private UserGroupService userGroupService;

    @CacheEvict(value={"roleCache", "roleRightCache"}, allEntries=true)
    public void addObj(Role role) {
        if (StringUtils.isBlank((String)role.getRoleCode())) {
            throw new CommonException("code\u503c\u4e0d\u80fd\u4e3a\u7a7a", "base_canot_be_null", new Object[]{"code\u503c"});
        }
        if (StringUtils.isBlank((String)role.getCompanyId())) {
            throw new CommonException("companyId\u4e0d\u80fd\u4e3a\u7a7a");
        }
        RoleExample example = new RoleExample();
        example.createCriteria().andRoleCodeEqualTo(role.getRoleCode()).andCompanyIdEqualTo(role.getCompanyId());
        example.or().andRoleCodeEqualTo(role.getRoleCode()).andCompanyIdIsNull();
        if (this.roleMapper.countByExample(example) > 0) {
            throw new CommonException("code\u503c\u5df2\u5b58\u5728", "base_is_exists", new Object[]{"code\u503c"});
        }
        if (role.getRoleName().length() > 50) {
            throw new CommonException("\u89d2\u8272\u540d\u957f\u5ea6\u4e0d\u80fd\u8d85\u8fc750", "length_canot_exceed", new Object[]{"\u89d2\u8272\u540d", "50"});
        }
        if (role.getRoleCode().length() > 20) {
            throw new CommonException("\u89d2\u8272\u7f16\u7801\u957f\u5ea6\u4e0d\u80fd\u8d85\u8fc720", "length_canot_exceed", new Object[]{"\u89d2\u8272\u7f16\u7801", "20"});
        }
        if (role.getRoleLevel() == null || role.getRoleLevel() < 0) {
            role.setRoleLevel(Role.ROLE_LEVEL_CUSTOM);
        }
        if (!Role.ROLE_LEVEL_SYS.equals(role.getRoleLevel()) && !Role.ROLE_LEVEL_CUSTOM.equals(role.getRoleLevel())) {
            throw new CommonException("\u975e\u6cd5\u7684\u89d2\u8272\u7ea7\u522b");
        }
        Date date = new Date();
        role.setCreateTime(date);
        role.setUpdateTime(date);
        this.roleMapper.insertSelective(role);
    }

    @CacheEvict(value={"roleCache", "roleRightCache"}, allEntries=true)
    public void deleteObjById(String roleId) {
        if (roleId.equals("1")) {
            throw new CommonException("\u7ba1\u7406\u5458,\u4e0d\u5141\u8bb8\u64cd\u4f5c", "admin_not_allow_oper");
        }
        this.roleMapper.deleteByPrimaryKey(roleId);
    }

    @CacheEvict(value={"roleCache", "roleRightCache"}, allEntries=true)
    public void modifyObj(Role role) {
        if (StringUtils.isBlank((String)role.getId())) {
            throw new CommonException("id \u4e0d\u80fd\u4e3a\u7a7a", "id_is_blank");
        }
        if (role.getRoleName().length() > 50) {
            throw new CommonException("\u89d2\u8272\u540d\u957f\u5ea6\u4e0d\u80fd\u8d85\u8fc750", "length_canot_exceed", new Object[]{"\u89d2\u8272\u540d", "50"});
        }
        if (role.getRoleCode().length() > 20) {
            throw new CommonException("\u89d2\u8272\u7f16\u7801\u957f\u5ea6\u4e0d\u80fd\u8d85\u8fc720", "length_canot_exceed", new Object[]{"\u89d2\u8272\u7f16\u7801", "20"});
        }
        RoleExample example = new RoleExample();
        if (StringUtils.isNotBlank((String)role.getRoleCode())) {
            example.createCriteria().andRoleCodeEqualTo(role.getRoleCode()).andIdNotEqualTo(role.getId()).andCompanyIdIsNull();
            if (StringUtils.isNotBlank((String)role.getCompanyId())) {
                example.or().andRoleCodeEqualTo(role.getRoleCode()).andIdNotEqualTo(role.getId()).andCompanyIdEqualTo(role.getCompanyId());
            }
            if (this.roleMapper.countByExample(example) > 0) {
                throw new CommonException("code\u503c\u5df2\u5b58\u5728", "base_is_exists", new Object[]{"code\u503c"});
            }
        }
        Date date = new Date();
        role.setUpdateTime(date);
        this.roleMapper.updateByPrimaryKeySelective(role);
    }

    @Override
    @Cacheable(value={"roleCache"}, keyGenerator="redisKeyGenerator")
    public Map<String, Set<String>> queryUserOperatorAction(boolean isAdmin, List<String> roleIds) {
        HashMap<String, Set<String>> rightMap = new HashMap<String, Set<String>>();
        if (isAdmin) {
            rightMap.put("menuAll", new HashSet());
        } else {
            RoleRightExample roleRightExample = new RoleRightExample();
            roleRightExample.createCriteria().andRoleIdIn((List)roleIds).andTypeEqualTo("operator");
            List rights = this.roleRightService.queryAllObjByExample((IExample)roleRightExample);
            for (RoleRight right : rights) {
                Operator operator = (Operator)this.operatorService.queryObjById(right.getKeyId());
                String menuCode = operator.getMenuCode();
                String operCode = operator.getOperCode();
                Set operSet = null;
                operSet = rightMap.containsKey(menuCode) ? (Set)rightMap.get(menuCode) : new HashSet();
                operSet.add(operCode);
                rightMap.put(menuCode, operSet);
            }
        }
        return rightMap;
    }

    @Override
    @Cacheable(value={"roleCache"}, keyGenerator="redisKeyGenerator")
    public List<Role> queryUserOwnAndCreateRoles(boolean isAdmin, String userId) {
        RoleExample roleExample = new RoleExample();
        if (isAdmin) {
            return this.roleMapper.selectByExample(roleExample);
        }
        UserRoleExample userRoleExample = new UserRoleExample();
        userRoleExample.createCriteria().andUserIdEqualTo(userId);
        List list = this.userRoleService.queryAllObjByExample((IExample)userRoleExample);
        ArrayList<String> roleIdList = new ArrayList<String>();
        for (UserRole userRole : list) {
            roleIdList.add(userRole.getRoleId());
        }
        roleExample.createCriteria().andCreateUserIdEqualTo(userId);
        roleExample.or().andIdIn(roleIdList);
        return this.queryAllObjByExample(roleExample);
    }

    @Override
    @Cacheable(value={"roleCache"}, keyGenerator="redisKeyGenerator")
    public Role queryRoleById(String roleId) {
        return this.roleMapper.selectByPrimaryKey(roleId);
    }

    @Override
    @Cacheable(value={"roleCache"}, keyGenerator="redisKeyGenerator")
    public List<Role> queryUserOwnRoles(String userId) {
        UserRoleExample userRoleExample = new UserRoleExample();
        userRoleExample.createCriteria().andUserIdEqualTo(userId);
        List list = this.userRoleService.queryAllObjByExample((IExample)userRoleExample);
        if (CollectionUtils.isEmpty((Collection)list)) {
            return null;
        }
        ArrayList<String> roleIdList = new ArrayList<String>();
        for (UserRole role : list) {
            roleIdList.add(role.getRoleId());
        }
        RoleExample roleExample = new RoleExample();
        roleExample.createCriteria().andIdIn(roleIdList);
        return this.queryAllObjByExample(roleExample);
    }

    @Cacheable(value={"roleCache"}, keyGenerator="redisKeyGenerator")
    public Role queryObjById(String id) {
        return this.roleMapper.selectByPrimaryKey(id);
    }

    @Cacheable(value={"roleCache"}, keyGenerator="redisKeyGenerator")
    public List<Role> queryAllObjByExample(RoleExample example) {
        return this.roleMapper.selectByExample(example);
    }

    @Cacheable(value={"roleCache"}, keyGenerator="redisKeyGenerator")
    public PageView<Role> queryObjByPage(RoleExample example) {
        PageView<Role> pageView = example.getPageView();
        pageView.setQueryResult(this.roleMapper.selectByExampleByPage(example));
        return pageView;
    }

    @Override
    public List<Role> queryAllRoleByUserGroup(String userGroupId) {
        ArrayList<String> userGroupIds = new ArrayList<String>();
        UserGroup userGroup = (UserGroup)((UserGroupService)SpringContextHolder.getOneBean(UserGroupService.class)).queryObjById(userGroupId);
        if (userGroup == null) {
            return null;
        }
        userGroupIds.add(userGroup.getId());
        for (UserGroup parents = ((UserGroupService)SpringContextHolder.getOneBean(UserGroupService.class)).queryParents(userGroupId); parents != null; parents = parents.getParent()) {
            userGroupIds.add(parents.getId());
        }
        UserGroupRoleRefExample example = new UserGroupRoleRefExample();
        example.createCriteria().andOganizationIdIn(userGroupIds);
        List<UserGroupRoleRef> refList = this.userGroupRoleRefMapper.selectByExample(example);
        if (CollectionUtils.isEmpty(refList)) {
            return null;
        }
        ArrayList<String> roleIds = new ArrayList<String>();
        for (UserGroupRoleRef ref : refList) {
            roleIds.add(ref.getRoleId());
        }
        RoleExample roleExample = new RoleExample();
        roleExample.createCriteria().andIdIn(roleIds);
        return this.queryAllObjByExample(roleExample);
    }

    @CacheEvict(value={"roleCache", "roleRightCache"}, allEntries=true)
    public void deleteByExample(RoleExample example) {
        Assert.isNotNull((Object)example, (String)"\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isNotEmpty(example.getOredCriteria(), (String)"\u6279\u91cf\u5220\u9664\u4e0d\u80fd\u5168\u8868\u5220\u9664");
        this.roleMapper.deleteByExample(example);
    }

    @CacheEvict(value={"roleCache", "roleRightCache"}, allEntries=true)
    @Transactional
    public void addAll(List<Role> list) {
        if (CollectionUtils.isEmpty(list)) {
            return;
        }
        list.forEach(record -> this.roleMapper.insertSelective((Role)record));
    }

    @Override
    @CacheEvict(value={"roleCache", "roleRightCache"}, allEntries=true)
    public void modifyByExample(Role role, RoleExample example) {
        Assert.isNotNull((Object)example, (String)"\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isNotEmpty(example.getOredCriteria(), (String)"\u6279\u91cf\u5220\u9664\u4e0d\u80fd\u5168\u8868\u5220\u9664");
        this.roleMapper.updateByExampleSelective(role, example);
    }
}

