/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.auth.service.impl;

import com.els.base.auth.dao.RoleMapper;
import com.els.base.auth.dao.RoleRightMapper;
import com.els.base.auth.entity.ButtonExample;
import com.els.base.auth.entity.Operator;
import com.els.base.auth.entity.OperatorExample;
import com.els.base.auth.entity.Role;
import com.els.base.auth.entity.RoleExample;
import com.els.base.auth.entity.RoleRight;
import com.els.base.auth.entity.RoleRightExample;
import com.els.base.auth.service.ButtonService;
import com.els.base.auth.service.MenuService;
import com.els.base.auth.service.OperatorService;
import com.els.base.auth.service.RoleRightService;
import com.els.base.core.entity.IExample;
import com.els.base.core.entity.PageView;
import com.els.base.core.exception.CommonException;
import com.els.base.core.utils.Assert;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class RoleRightServiceImpl
implements RoleRightService {
    @Resource
    protected MenuService menuService;
    @Resource
    protected ButtonService buttonService;
    @Resource
    private RoleRightMapper roleRightMapper;
    @Resource
    private RoleMapper roleMapper;
    @Resource
    private OperatorService operatorService;

    @CacheEvict(value={"roleRightCache", "menu"}, allEntries=true)
    public void addObj(RoleRight roleRight) {
        this.roleRightMapper.insertSelective(roleRight);
    }

    @CacheEvict(value={"roleRightCache", "menu"}, allEntries=true)
    public void deleteObjById(String id) {
        this.roleRightMapper.deleteByPrimaryKey(id);
    }

    @CacheEvict(value={"roleRightCache", "menu"}, allEntries=true)
    public void modifyObj(RoleRight t) {
        if (StringUtils.isBlank((String)t.getId()) || StringUtils.isBlank((String)t.getKeyId()) || StringUtils.isBlank((String)t.getRoleId()) || StringUtils.isBlank((String)t.getType())) {
            throw new IllegalArgumentException("\u53c2\u6570\u4e0d\u5168\uff0c\u6ca1\u6cd5\u4fee\u6539");
        }
        this.roleRightMapper.updateByPrimaryKeySelective(t);
    }

    @Cacheable(value={"roleRightCache"}, keyGenerator="redisKeyGenerator")
    public RoleRight queryObjById(String id) {
        return this.roleRightMapper.selectByPrimaryKey(id);
    }

    @Cacheable(value={"roleRightCache"}, keyGenerator="redisKeyGenerator")
    public List<RoleRight> queryAllObjByExample(RoleRightExample example) {
        return this.roleRightMapper.selectByExample(example);
    }

    @Cacheable(value={"roleRightCache"}, keyGenerator="redisKeyGenerator")
    public PageView<RoleRight> queryObjByPage(RoleRightExample example) {
        PageView<RoleRight> pageView = example.getPageView();
        pageView.setQueryResult(this.roleRightMapper.selectByExampleByPage(example));
        return pageView;
    }

    @Override
    @Cacheable(value={"roleRightCache"}, keyGenerator="redisKeyGenerator")
    public List<Role> getRoleByOperatorUrl(String url) {
        OperatorExample operatorExample = new OperatorExample();
        operatorExample.createCriteria().andOperUrlEqualTo(url);
        if (!url.contains(".html")) {
            operatorExample.or().andOperUrlEqualTo(url + ".html");
        }
        List operList = this.operatorService.queryAllObjByExample((IExample)operatorExample);
        ArrayList<String> operIdList = new ArrayList<String>();
        for (int i = 0; i < operList.size(); ++i) {
            operIdList.add(((Operator)operList.get(i)).getId().toString());
        }
        if (CollectionUtils.isEmpty(operIdList)) {
            return null;
        }
        RoleRightExample roleRightExample = new RoleRightExample();
        roleRightExample.createCriteria().andKeyIdIn(operIdList).andTypeEqualTo("operator");
        List<RoleRight> roleRightList = this.roleRightMapper.selectByExample(roleRightExample);
        ArrayList<String> roleIdList = new ArrayList<String>();
        for (int i = 0; i < roleRightList.size(); ++i) {
            roleIdList.add(roleRightList.get(i).getRoleId());
        }
        if (CollectionUtils.isEmpty(roleIdList)) {
            return null;
        }
        RoleExample roleExample = new RoleExample();
        roleExample.createCriteria().andIdIn(roleIdList);
        List<Role> roleList = this.roleMapper.selectByExample(roleExample);
        return roleList;
    }

    @Override
    @CacheEvict(value={"roleRightCache", "menu"}, allEntries=true)
    public void deleteByExample(RoleRightExample example) {
        Assert.isNotNull((Object)((Object)example), (String)"\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isNotEmpty(example.getOredCriteria(), (String)"\u6279\u91cf\u5220\u9664\u4e0d\u80fd\u5168\u8868\u5220\u9664");
        this.roleRightMapper.deleteByExample(example);
    }

    @CacheEvict(value={"roleRightCache", "menu"}, allEntries=true)
    @Transactional
    public void addAll(List<RoleRight> list) {
        if (CollectionUtils.isEmpty(list)) {
            return;
        }
        list.forEach(record -> this.roleRightMapper.insertSelective((RoleRight)record));
    }

    @Override
    @CacheEvict(value={"roleRightCache", "menu"}, allEntries=true)
    @Transactional
    public void authorized(String roleId, List<RoleRight> rights) {
        this.authorized(roleId, rights, "menu");
    }

    @Override
    @CacheEvict(value={"roleRightCache", "menu"}, allEntries=true)
    public void authorized(String roleId, List<RoleRight> rights, String menuType) {
        if (StringUtils.isBlank((String)menuType)) {
            throw new CommonException("\u83dc\u5355\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
        }
        for (RoleRight roleRight : rights) {
            if (StringUtils.isBlank((String)roleRight.getType())) {
                throw new CommonException("\u53c2\u6570[type]\u4e0d\u80fd\u4e3a\u7a7a", "base_canot_be_null", new Object[]{"\u53c2\u6570[type]"});
            }
            if (StringUtils.isBlank((String)roleRight.getKeyId())) {
                throw new CommonException("\u53c2\u6570[keyId]\u4e0d\u80fd\u4e3a\u7a7a", "base_canot_be_null", new Object[]{"\u53c2\u6570[keyId]"});
            }
            roleRight.setRoleId(roleId);
        }
        this.deleteRight(roleId, rights, menuType);
        for (RoleRight roleRight : rights) {
            this.roleRightMapper.insertSelective(roleRight);
        }
    }

    private void deleteRight(String roleId, List<RoleRight> rights, String menuType) {
        boolean isMatch;
        if (CollectionUtils.isNotEmpty(rights) && !(isMatch = rights.stream().anyMatch(right -> right.getType().equals(menuType)))) {
            throw new CommonException("\u83dc\u5355\u7c7b\u578b\u4e0d\u4e00\u81f4");
        }
        RoleRightExample example = new RoleRightExample();
        example.createCriteria().andRoleIdEqualTo(roleId).andTypeEqualTo(menuType);
        List<RoleRight> roleRightList = this.roleRightMapper.selectByExample(example);
        if (CollectionUtils.isEmpty(roleRightList)) {
            return;
        }
        ArrayList roleRightIds = new ArrayList();
        List menuIds = roleRightList.stream().map(RoleRight::getKeyId).collect(Collectors.toList());
        roleRightIds.addAll(menuIds);
        ButtonExample buttonExample = new ButtonExample();
        buttonExample.createCriteria().andMenuIdIn(menuIds);
        List buttonList = this.buttonService.queryAllObjByExample((IExample)buttonExample);
        if (CollectionUtils.isNotEmpty((Collection)buttonList)) {
            buttonList.forEach(button -> roleRightIds.add(button.getId()));
        }
        OperatorExample operatorExample = new OperatorExample();
        operatorExample.createCriteria().andMenuIdIn(menuIds);
        List operatorList = this.operatorService.queryAllObjByExample((IExample)operatorExample);
        if (CollectionUtils.isNotEmpty((Collection)operatorList)) {
            operatorList.forEach(operator -> roleRightIds.add(operator.getId()));
        }
        RoleRightExample roleRightExample = new RoleRightExample();
        roleRightExample.createCriteria().andKeyIdIn((List)roleRightIds).andRoleIdEqualTo(roleId);
        this.roleRightMapper.deleteByExample(roleRightExample);
    }
}

