/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.auth.web.controller;

import com.els.base.auth.entity.Operator;
import com.els.base.auth.entity.OperatorExample;
import com.els.base.auth.service.OperatorService;
import com.els.base.core.entity.IExample;
import com.els.base.core.entity.PageView;
import com.els.base.core.entity.ResponseResult;
import com.els.base.core.exception.CommonException;
import com.els.base.core.utils.Assert;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import javax.annotation.Resource;
import org.apache.commons.lang.StringUtils;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Api(value="\u6743\u9650\u7ba1\u7406-\u63a5\u53e3\u8bf7\u6c42url")
@Controller
@RequestMapping(value={"operator"})
public class OperatorController {
    @Resource
    private OperatorService operatorService;

    @ApiOperation(value="\u6dfb\u52a0\u8bf7\u6c42url", httpMethod="POST")
    @RequestMapping(value={"service/addOperator"})
    @ResponseBody
    public ResponseResult<String> addOperator(@RequestBody Operator operator) {
        Assert.isNotBlank((String)operator.getMenuId(), (String)"\u6570\u636e\u8fd8\u6ca1\u6709\u5173\u8054\u83dc\u5355");
        Assert.isNotBlank((String)operator.getOperCode(), (String)"code\u4e0d\u80fd\u4e3a\u7a7a");
        operator.setId(null);
        this.operatorService.addObj(operator);
        return ResponseResult.success();
    }

    @ApiOperation(value="\u5220\u9664\u8bf7\u6c42url", httpMethod="GET")
    @RequestMapping(value={"service/deleteOperator"})
    @ResponseBody
    public ResponseResult<String> deleteOperator(@RequestParam(required=true) String id) {
        this.operatorService.deleteObjById(id);
        return ResponseResult.success();
    }

    @ApiOperation(value="\u4fee\u6539\u8bf7\u6c42url", httpMethod="POST")
    @RequestMapping(value={"service/modifyOperator"})
    @ResponseBody
    public ResponseResult<String> modifyOperator(@RequestBody Operator operator) {
        if (StringUtils.isBlank((String)operator.getId())) {
            throw new CommonException("id\u4e3a\u7a7a", "id_is_blank");
        }
        this.operatorService.modifyObj(operator);
        return ResponseResult.success();
    }

    @ApiOperation(value="\u67e5\u8be2\u83dc\u5355\u4e0b\u7684\u8bf7\u6c42url", httpMethod="GET")
    @RequestMapping(value={"service/queryMenuOperatorList"})
    @ResponseBody
    public ResponseResult<PageView<Operator>> queryMenuOperatorList(@ApiParam(value="\u6240\u5728\u9875", defaultValue="1") @RequestParam(defaultValue="1") int pageNo, @ApiParam(value="\u6bcf\u9875\u6570\u91cf", defaultValue="10") @RequestParam(defaultValue="10") int pageSize, @ApiParam(value="\u83dc\u5355id", defaultValue="10") @RequestParam(required=true) String menuId) {
        OperatorExample operatorExample = new OperatorExample();
        operatorExample.setPageView((PageView<Operator>)new PageView(pageNo, pageSize));
        operatorExample.createCriteria().andMenuIdEqualTo(menuId);
        return ResponseResult.success((Object)this.operatorService.queryObjByPage((IExample)operatorExample));
    }
}

