/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.auth.web.security.impl;

import com.els.base.auth.entity.AuthUser;
import com.els.base.auth.exception.PcpErrorException;
import com.els.base.utils.encryption.DESUtils;
import com.sinolife.sf.login.util.HttpLoginResult;
import com.sinolife.sf.login.util.SsoLoginUtil;
import org.springframework.security.authentication.BadCredentialsException;
import org.springframework.security.authentication.InternalAuthenticationServiceException;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.authentication.dao.AbstractUserDetailsAuthenticationProvider;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.security.core.userdetails.UserDetailsService;
import org.springframework.security.core.userdetails.UsernameNotFoundException;
import org.springframework.security.crypto.password.PasswordEncoder;
import org.springframework.util.StringUtils;

public class CustomDaoAuthenticationProvider
extends AbstractUserDetailsAuthenticationProvider {
    private PasswordEncoder passwordEncoder;
    private UserDetailsService userDetailsService;
    private String isEnable;
    private String loginApiIsEnable;

    protected void additionalAuthenticationChecks(UserDetails userDetails, UsernamePasswordAuthenticationToken authentication) throws AuthenticationException {
        String salt = null;
        AuthUser user = (AuthUser)userDetails;
        if (user != null) {
            salt = user.getPasswordKey();
        }
        if (authentication.getCredentials() == null) {
            this.logger.debug((Object)"Authentication failed: no credentials provided");
            throw new BadCredentialsException(this.messages.getMessage("AbstractUserDetailsAuthenticationProvider.badCredentials", "Bad credentials"));
        }
        String presentedPassword = authentication.getCredentials().toString();
        if ("true".equals(this.loginApiIsEnable)) {
            if (StringUtils.isEmpty((Object)user.getCreateSource())) {
                this.srmCheck(userDetails, salt, presentedPassword);
            } else if ("1".equals(user.getCreateSource().trim())) {
                if ("true".equals(this.isEnable)) {
                    this.checkPcpSystemUserLogin(user, presentedPassword);
                } else {
                    this.srmCheck(userDetails, salt, presentedPassword);
                }
            } else {
                this.srmCheck(userDetails, salt, presentedPassword);
            }
        } else {
            this.srmCheck(userDetails, salt, presentedPassword);
        }
    }

    private void srmCheck(UserDetails userDetails, Object salt, String presentedPassword) {
        if (salt != null) {
            try {
                presentedPassword = DESUtils.encrypt((String)presentedPassword, (String)"tissonco") + salt.toString();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (!this.passwordEncoder.matches((CharSequence)presentedPassword, userDetails.getPassword())) {
            this.logger.debug((Object)"Authentication failed: password does not match stored value");
            throw new BadCredentialsException(this.messages.getMessage("AbstractUserDetailsAuthenticationProvider.badCredentials", "Bad credentials"));
        }
    }

    private void checkPcpSystemUserLogin(AuthUser user, String presentedPassword) {
        try {
            HttpLoginResult login = SsoLoginUtil.login(user.getEmail(), presentedPassword);
            if (login == null) {
                throw new PcpErrorException("\u767b\u5f55esb\u5185\u7f51\u8ba4\u8bc1\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5\uff01");
            }
            if (!login.isSuccess()) {
                throw new PcpErrorException(login.getErrorMessage());
            }
        }
        catch (Exception e) {
            throw new PcpErrorException(e.getMessage());
        }
    }

    protected UserDetails retrieveUser(String username, UsernamePasswordAuthenticationToken authentication) throws AuthenticationException {
        UserDetails loadedUser;
        try {
            loadedUser = this.getUserDetailsService().loadUserByUsername(username);
        }
        catch (UsernameNotFoundException notFound) {
            throw notFound;
        }
        catch (Exception repositoryProblem) {
            throw new InternalAuthenticationServiceException(repositoryProblem.getMessage(), (Throwable)repositoryProblem);
        }
        if (loadedUser == null) {
            throw new InternalAuthenticationServiceException("UserDetailsService returned null, which is an interface contract violation");
        }
        return loadedUser;
    }

    public void setUserDetailsService(UserDetailsService userDetailsService) {
        this.userDetailsService = userDetailsService;
    }

    protected UserDetailsService getUserDetailsService() {
        return this.userDetailsService;
    }

    public PasswordEncoder getPasswordEncoder() {
        return this.passwordEncoder;
    }

    public void setPasswordEncoder(PasswordEncoder passwordEncoder) {
        this.passwordEncoder = passwordEncoder;
    }

    public String getIsEnable() {
        return this.isEnable;
    }

    public void setIsEnable(String isEnable) {
        this.isEnable = isEnable;
    }

    public String getLoginApiIsEnable() {
        return this.loginApiIsEnable;
    }

    public void setLoginApiIsEnable(String loginApiIsEnable) {
        this.loginApiIsEnable = loginApiIsEnable;
    }
}

