package com.els.base.autoupdate.service;

import java.util.List;

import com.els.base.autoupdate.entity.UpgradeLog;
import com.els.base.autoupdate.entity.UpgradeLogExample;
import com.els.base.core.service.BaseService;

public interface UpgradeLogService extends BaseService<UpgradeLog, UpgradeLogExample, String> {

	/**
	 * 查询最后升级记录对象
	 * @return
	 */
	UpgradeLog findLastUpdateLog();
	
	/**
	 * 初始化一个新的更新日志，作为起点
	 */
	public void initNewUpdateLog();
	
	/**
	 * 通过Mybatis来执行sql语句
	 * @param sqlList
	 */
	void executeSql(List<String> sql);
	
	/**
	 * 查询该sql语句是否有执行成功的记录
	 * @param fileName
	 * @return
	 */
	boolean hasSuccessRecord(String fileName);
	
}	