/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.autoupdate.service.impl;

import com.els.base.autoupdate.dao.UpgradeLogMapper;
import com.els.base.autoupdate.entity.UpgradeLog;
import com.els.base.autoupdate.entity.UpgradeLogExample;
import com.els.base.autoupdate.service.UpgradeLogService;
import com.els.base.core.dao.CommonMapper;
import com.els.base.core.entity.PageView;
import com.els.base.core.exception.CommonException;
import com.els.base.core.utils.Assert;
import com.els.base.core.utils.Constant;
import java.text.MessageFormat;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="upgradeLogService")
public class UpgradeLogServiceImpl
implements UpgradeLogService {
    private static final Logger logger = LoggerFactory.getLogger(UpgradeLogServiceImpl.class);
    @Resource
    protected UpgradeLogMapper upgradeLogMapper;
    @Resource
    protected CommonMapper commonMapper;

    @CacheEvict(value={"upgradeLog"}, allEntries=true)
    public void addObj(UpgradeLog t) {
        this.upgradeLogMapper.insertSelective(t);
    }

    @CacheEvict(value={"upgradeLog"}, allEntries=true)
    public void deleteObjById(String id) {
        this.upgradeLogMapper.deleteByPrimaryKey(id);
    }

    @CacheEvict(value={"upgradeLog"}, allEntries=true)
    public void modifyObj(UpgradeLog t) {
        if (StringUtils.isBlank((String)t.getId())) {
            throw new CommonException("id \u4e3a\u7a7a\uff0c\u65e0\u6cd5\u66f4\u65b0");
        }
        this.upgradeLogMapper.updateByPrimaryKeySelective(t);
    }

    @Cacheable(value={"upgradeLog"}, keyGenerator="redisKeyGenerator")
    public UpgradeLog queryObjById(String id) {
        return this.upgradeLogMapper.selectByPrimaryKey(id);
    }

    @Cacheable(value={"upgradeLog"}, keyGenerator="redisKeyGenerator")
    public List<UpgradeLog> queryAllObjByExample(UpgradeLogExample example) {
        return this.upgradeLogMapper.selectByExample(example);
    }

    @Cacheable(value={"upgradeLog"}, keyGenerator="redisKeyGenerator")
    public PageView<UpgradeLog> queryObjByPage(UpgradeLogExample example) {
        PageView<UpgradeLog> pageView = example.getPageView();
        pageView.setQueryResult(this.upgradeLogMapper.selectByExampleByPage(example));
        return pageView;
    }

    @Override
    @Cacheable(value={"upgradeLog"}, keyGenerator="redisKeyGenerator")
    public UpgradeLog findLastUpdateLog() {
        UpgradeLogExample example = new UpgradeLogExample();
        example.createCriteria().andIsSuccessEqualTo(Constant.YES_INT);
        example.setOrderByClause("LAST_UPDATE_TIME DESC");
        example.setPageView((PageView<UpgradeLog>)new PageView(1, 1));
        List<UpgradeLog> upgradeLogList = this.upgradeLogMapper.selectByExampleByPage(example);
        if (CollectionUtils.isEmpty(upgradeLogList)) {
            return null;
        }
        return upgradeLogList.get(0);
    }

    @Override
    @Transactional
    public void executeSql(List<String> sqlList) {
        if (CollectionUtils.isEmpty(sqlList)) {
            return;
        }
        for (String sql : sqlList) {
            try {
                logger.info("sql:/n" + sql);
                this.commonMapper.execute(sql);
            }
            catch (Exception e) {
                String format = MessageFormat.format("sql\u6267\u884c\u5f02\u5e38,sql:\n{0}\n\u5f02\u5e38:\n{1}", sql, e.getMessage());
                throw new CommonException(format);
            }
        }
    }

    @Override
    @CacheEvict(value={"upgradeLog"}, allEntries=true)
    public void initNewUpdateLog() {
        UpgradeLog log = new UpgradeLog();
        log.setLastUpdateTime(new Date());
        log.setIsSuccess(Constant.YES_INT);
        this.upgradeLogMapper.insertSelective(log);
    }

    @Override
    @Cacheable(value={"upgradeLog"}, keyGenerator="redisKeyGenerator")
    public boolean hasSuccessRecord(String fileName) {
        UpgradeLogExample example = new UpgradeLogExample();
        example.createCriteria().andSqlFileNameEqualTo(fileName).andIsSuccessEqualTo(Constant.YES_INT);
        return this.upgradeLogMapper.countByExample(example) > 0;
    }

    @CacheEvict(value={"upgradeLog"}, allEntries=true)
    public void deleteByExample(UpgradeLogExample example) {
        Assert.isNotNull((Object)example, (String)"\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isNotEmpty(example.getOredCriteria(), (String)"\u6279\u91cf\u5220\u9664\u4e0d\u80fd\u5168\u8868\u5220\u9664");
        this.upgradeLogMapper.deleteByExample(example);
    }

    @CacheEvict(value={"upgradeLog"}, allEntries=true)
    @Transactional
    public void addAll(List<UpgradeLog> list) {
        if (CollectionUtils.isEmpty(list)) {
            return;
        }
        list.forEach(record -> this.upgradeLogMapper.insertSelective((UpgradeLog)record));
    }
}

