/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.autoupdate.utils;

import com.els.base.core.web.context.support.McodingBeanDefinitionReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.nio.charset.Charset;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.ibatis.io.Resources;
import org.apache.ibatis.jdbc.ScriptRunner;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;
import org.springframework.util.FileCopyUtils;

public class UpgradeLogUtils {
    protected static final Logger logger = LoggerFactory.getLogger(UpgradeLogUtils.class);
    public static final SimpleDateFormat PARSE_PATTERN = new SimpleDateFormat("yyyyMMddHHmm");
    public static final Pattern FILE_NAME_PATTERN = Pattern.compile("^[\\w+\\-\\_]+\\-(\\d{12})\\.sql$");

    public static List<Resource> findUpdateSqlFile(Date date) throws ParseException, IOException {
        if (date == null) {
            throw new IllegalArgumentException("The date must not be null");
        }
        ArrayList<Resource> fileList = new ArrayList<Resource>();
        PathMatchingResourcePatternResolver resourceResolver = new PathMatchingResourcePatternResolver();
        Resource[] resources = resourceResolver.getResources("classpath*:/sql/*.sql");
        long time2 = date.getTime();
        for (Resource f : resources) {
            String fileName = f.getFilename();
            Matcher matcher = FILE_NAME_PATTERN.matcher(fileName);
            if (!matcher.find()) {
                throw new IllegalArgumentException("\u65e0\u6cd5\u8fdb\u884c\u7cfb\u7edf\u5347\u7ea7,sql\u5347\u7ea7\u6587\u4ef6\u683c\u5f0f\u5f02\u5e38\uff0c\u6587\u4ef6\u540d\u3010" + fileName + "\u3011");
            }
            String fileDate = matcher.group(1);
            long time1 = PARSE_PATTERN.parse(fileDate).getTime();
            if (time1 <= time2) continue;
            fileList.add(f);
        }
        UpgradeLogUtils.sort(fileList);
        return fileList;
    }

    public static void sort(List<Resource> fileList) {
        Collections.sort(fileList, new Comparator<Resource>(){

            @Override
            public int compare(Resource file1, Resource file2) {
                String fileName1 = file1.getFilename();
                Matcher matcher1 = FILE_NAME_PATTERN.matcher(fileName1);
                matcher1.find();
                String fDate1 = matcher1.group(1);
                String fileName2 = file2.getFilename();
                Matcher matcher2 = FILE_NAME_PATTERN.matcher(fileName2);
                matcher2.find();
                String fDate2 = matcher2.group(1);
                try {
                    Long time1 = PARSE_PATTERN.parse(fDate1).getTime();
                    Long time2 = PARSE_PATTERN.parse(fDate2).getTime();
                    return time1.compareTo(time2);
                }
                catch (ParseException e) {
                    e.printStackTrace();
                    return 0;
                }
            }
        });
    }

    public static List<String> readSQLContent(List<Resource> sqlFileList) throws IOException {
        if (CollectionUtils.isEmpty(sqlFileList)) {
            return null;
        }
        ArrayList<String> sqlList = new ArrayList<String>();
        for (Resource file : sqlFileList) {
            List<String> tempSqlList = UpgradeLogUtils.readSQLContent(file);
            if (!CollectionUtils.isNotEmpty(tempSqlList)) continue;
            sqlList.addAll(tempSqlList);
        }
        return sqlList;
    }

    public static List<String> readSQLContent(Resource sqlFile) throws IOException {
        String[] sql;
        ArrayList<String> sqlList = new ArrayList<String>();
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream(1024);
        InputStream inputStream = sqlFile.getInputStream();
        FileCopyUtils.copy((InputStream)inputStream, (OutputStream)outputStream);
        outputStream.flush();
        outputStream.close();
        String sql1 = new String(outputStream.toByteArray(), Charset.forName("UTF-8"));
        sql1 = UpgradeLogUtils.removeSQLComment(sql1);
        for (String string : sql = sql1.split(";")) {
            if (StringUtils.isBlank((String)string)) continue;
            sqlList.add(string.trim());
        }
        return sqlList;
    }

    public static void runSqlScript(List<File> sqlFileList) {
        try {
            Properties dbProps = new Properties();
            try {
                dbProps.load(McodingBeanDefinitionReader.class.getClassLoader().getResourceAsStream("conf.properties"));
                McodingBeanDefinitionReader.class.getClassLoader().getResource("").getPath();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            String driveClassName = dbProps.getProperty("db.driver.class");
            String url = dbProps.getProperty("db.url");
            String username = dbProps.getProperty("db.username");
            String password = dbProps.getProperty("db.password");
            Class.forName(driveClassName).newInstance();
            Connection conn = DriverManager.getConnection(url, username, password);
            ScriptRunner runner = new ScriptRunner(conn);
            Resources.setCharset((Charset)Charset.forName("UTF-8"));
            PrintWriter logWriter = new PrintWriter(System.out);
            runner.setLogWriter(logWriter);
            runner.setAutoCommit(false);
            runner.setErrorLogWriter(logWriter);
            runner.setStopOnError(true);
            for (File file : sqlFileList) {
                runner.runScript((Reader)new FileReader(file));
            }
            runner.closeConnection();
            conn.close();
        }
        catch (IOException | ClassNotFoundException | IllegalAccessException | InstantiationException | SQLException e) {
            e.printStackTrace();
        }
    }

    public static void runSqlString(List<String> sqlFileList) throws SQLException {
        if (CollectionUtils.isNotEmpty(sqlFileList)) {
            Connection conn = null;
            Statement stmt = null;
            try {
                Properties dbProps = new Properties();
                dbProps.load(McodingBeanDefinitionReader.class.getClassLoader().getResourceAsStream("conf.properties"));
                McodingBeanDefinitionReader.class.getClassLoader().getResource("").getPath();
                String driveClassName = dbProps.getProperty("db.driver.class");
                String url = dbProps.getProperty("db.url");
                String username = dbProps.getProperty("db.username");
                String password = dbProps.getProperty("db.password");
                Class.forName(driveClassName).newInstance();
                conn = DriverManager.getConnection(url, username, password);
                conn.setAutoCommit(false);
                stmt = conn.createStatement();
                try {
                    for (String sql : sqlFileList) {
                        if (!StringUtils.isNotBlank((String)sql)) continue;
                        logger.info("\u6dfb\u52a0\u8bed\u53e5\u5230\u6279\u5904\u7406\u5f00\u59cb");
                        logger.info(sql);
                        logger.info("\u6dfb\u52a0\u8bed\u53e5\u5230\u6279\u5904\u7406\u7ed3\u675f");
                        stmt.addBatch(sql);
                    }
                    stmt.executeBatch();
                    conn.commit();
                }
                catch (Exception e) {
                    conn.rollback();
                    conn.close();
                    stmt.close();
                    e.printStackTrace();
                }
            }
            catch (Exception e) {
                conn.rollback();
                stmt.close();
                conn.close();
                e.printStackTrace();
            }
        }
    }

    public static String removeSQLComment(String sql) {
        Pattern pattern = Pattern.compile("(-{2,}.*?\\n)|(\\/\\*.*?\\*\\/)", 32);
        Matcher matcher = pattern.matcher(sql);
        sql = matcher.replaceAll("");
        return sql;
    }
}

