package com.els.base.autoupdate.service.impl;

import java.text.MessageFormat;
import java.util.Date;
import java.util.List;

import javax.annotation.Resource;

import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.els.base.autoupdate.dao.UpgradeLogMapper;
import com.els.base.autoupdate.entity.UpgradeLog;
import com.els.base.autoupdate.entity.UpgradeLogExample;
import com.els.base.autoupdate.service.UpgradeLogService;
import com.els.base.core.dao.CommonMapper;
import com.els.base.core.entity.PageView;
import com.els.base.core.exception.CommonException;
import com.els.base.core.utils.Assert;
import com.els.base.core.utils.Constant;

@Service("upgradeLogService")
public class UpgradeLogServiceImpl implements UpgradeLogService {
	
	private static final Logger logger = LoggerFactory.getLogger(UpgradeLogServiceImpl.class);
	
    @Resource
    protected UpgradeLogMapper upgradeLogMapper;
    
    @Resource
    protected CommonMapper commonMapper;

    @CacheEvict(value={"upgradeLog"}, allEntries=true)
    @Override
    public void addObj(UpgradeLog t) {
        this.upgradeLogMapper.insertSelective(t);
    }

    @CacheEvict(value={"upgradeLog"}, allEntries=true)
    @Override
    public void deleteObjById(String id) {
        this.upgradeLogMapper.deleteByPrimaryKey(id);
    }

    @CacheEvict(value={"upgradeLog"}, allEntries=true)
    @Override
    public void modifyObj(UpgradeLog t) {
        if (StringUtils.isBlank(t.getId())) {
            throw new CommonException("id 为空，无法更新");
        }
        this.upgradeLogMapper.updateByPrimaryKeySelective(t);
    }

    @Cacheable(value="upgradeLog", keyGenerator="redisKeyGenerator")
    @Override
    public UpgradeLog queryObjById(String id) {
        return this.upgradeLogMapper.selectByPrimaryKey(id);
    }

    @Cacheable(value="upgradeLog", keyGenerator="redisKeyGenerator")
    @Override
    public List<UpgradeLog> queryAllObjByExample(UpgradeLogExample example) {
        return this.upgradeLogMapper.selectByExample(example);
    }

    @Cacheable(value="upgradeLog", keyGenerator="redisKeyGenerator")
    @Override
    public PageView<UpgradeLog> queryObjByPage(UpgradeLogExample example) {
        PageView<UpgradeLog> pageView = example.getPageView();
        pageView.setQueryResult(this.upgradeLogMapper.selectByExampleByPage(example));
        return pageView;
    }

    @Cacheable(value="upgradeLog", keyGenerator="redisKeyGenerator")
	@Override
	public UpgradeLog findLastUpdateLog() {
		UpgradeLogExample example =new UpgradeLogExample();
		
		example.createCriteria().andIsSuccessEqualTo(Constant.YES_INT);
		example.setOrderByClause("LAST_UPDATE_TIME DESC");
		example.setPageView(new PageView<UpgradeLog>(1,1));
		
		List<UpgradeLog> upgradeLogList=upgradeLogMapper.selectByExampleByPage(example);
		if(CollectionUtils.isEmpty(upgradeLogList)){
			return null;
		}
		return upgradeLogList.get(0);
	}

    @Transactional
	@Override
	public void executeSql(List<String> sqlList) {
    	if (CollectionUtils.isEmpty(sqlList)) {
			return;
		}
    	
    	for (String sql : sqlList) {
    		try {
    			logger.info("sql:/n" + sql);
//    			this.upgradeLogMapper.executeSql(sql);
    			this.commonMapper.execute(sql);
    			
    		} catch (Exception e) {
    			String format = MessageFormat.format("sql执行异常,sql:\n{0}\n异常:\n{1}", sql, e.getMessage());
    			throw new CommonException(format);
    		}
    	}
	}

    @CacheEvict(value={"upgradeLog"}, allEntries=true)
	@Override
	public void initNewUpdateLog() {
		UpgradeLog log = new UpgradeLog();
		log.setLastUpdateTime(new Date());
		log.setIsSuccess(Constant.YES_INT);
		this.upgradeLogMapper.insertSelective(log);
	}

    @Cacheable(value="upgradeLog", keyGenerator="redisKeyGenerator")
	@Override
	public boolean hasSuccessRecord(String fileName) {
		UpgradeLogExample example = new UpgradeLogExample();
		example.createCriteria()
		       .andSqlFileNameEqualTo(fileName)
		       .andIsSuccessEqualTo(Constant.YES_INT);
		
		return this.upgradeLogMapper.countByExample(example) > 0;
	}

    @CacheEvict(value={"upgradeLog"}, allEntries=true)
	@Override
	public void deleteByExample(UpgradeLogExample example) {
    	Assert.isNotNull(example, "参数不能为空");
    	Assert.isNotEmpty(example.getOredCriteria(), "批量删除不能全表删除");
    	
		this.upgradeLogMapper.deleteByExample(example);
	}

    @CacheEvict(value={"upgradeLog"}, allEntries=true)
    @Transactional
	@Override
	public void addAll(List<UpgradeLog> list) {
		if (CollectionUtils.isEmpty(list)) {
			return;
		}
		
		list.forEach(record->{
			this.upgradeLogMapper.insertSelective(record);
		});
	}
}