package com.els.base.autoupdate.web.controller;

import javax.annotation.Resource;

import org.apache.commons.lang.StringUtils;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

import com.els.base.autoupdate.entity.UpgradeLog;
import com.els.base.autoupdate.entity.UpgradeLogExample;
import com.els.base.autoupdate.service.UpgradeLogService;
import com.els.base.core.entity.PageView;
import com.els.base.core.entity.ResponseResult;
import com.els.base.core.exception.CommonException;
import com.els.base.core.utils.CriteriaUtils;
import com.els.base.core.utils.query.QueryParamWapper;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;

@Api(value="升级日志操作")
@Controller
@RequestMapping("upgradeLog")
public class UpgradeLogController {
	
    @Resource
    protected UpgradeLogService upgradeLogService;

    @ApiOperation(httpMethod="POST", value="创建升级日志")
    @RequestMapping("service/create")
    @ResponseBody
    public ResponseResult<String> create(@RequestBody UpgradeLog upgradeLog) {
        this.upgradeLogService.addObj(upgradeLog);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="编辑升级日志")
    @RequestMapping("service/edit")
    @ResponseBody
    public ResponseResult<String> edit(@RequestBody UpgradeLog upgradeLog) {
        if (StringUtils.isBlank(upgradeLog.getId())) {
            throw new CommonException("id 为空，保存失败");
        }
        this.upgradeLogService.modifyObj(upgradeLog);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="删除升级日志")
    @RequestMapping("service/deleteById")
    @ResponseBody
    public ResponseResult<String> deleteById(@RequestParam(required=true) String id) {
        if (StringUtils.isBlank(id)) {
            throw new CommonException("删除失败,id不能为空");
        }
        this.upgradeLogService.deleteObjById(id);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="查询升级日志")
    @RequestMapping("service/findByPage")
    @ResponseBody
    public ResponseResult<PageView<UpgradeLog>> findByPage(
    		@ApiParam(value="所在页",defaultValue="0") @RequestParam(defaultValue="0") int pageNo, 
    		@ApiParam(value="每页数量",defaultValue="10") @RequestParam(defaultValue="10") int pageSize, 
    		@ApiParam(value="查询条件,属性名请参考 UpgradeLog") 
    		@RequestBody(required=false) QueryParamWapper wapper) {
    	
        UpgradeLogExample example = new UpgradeLogExample();
        example.setPageView(new PageView<UpgradeLog>(pageNo, pageSize));
        
        if (wapper != null) {
            UpgradeLogExample.Criteria criteria = example.createCriteria();
            CriteriaUtils.addCriterion(criteria, wapper);
        }
        
        PageView<UpgradeLog> pageData = this.upgradeLogService.queryObjByPage(example);
        return ResponseResult.success(pageData);
    }
}